/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamDwrfCheckpoint;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class LongInputStreamDwrf
implements LongInputStream {
    private final OrcInputStream input;
    private final OrcType.OrcTypeKind orcTypeKind;
    private final boolean signed;
    private final boolean usesVInt;

    public LongInputStreamDwrf(OrcInputStream input, OrcType.OrcTypeKind type, boolean signed, boolean usesVInt) {
        this.input = input;
        this.orcTypeKind = type;
        this.signed = signed;
        this.usesVInt = usesVInt;
    }

    @Override
    public Class<LongStreamDwrfCheckpoint> getCheckpointType() {
        return LongStreamDwrfCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamDwrfCheckpoint dwrfCheckpoint = (LongStreamDwrfCheckpoint)checkpoint;
        this.input.seekToCheckpoint(dwrfCheckpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        for (long i = 0L; i < items; ++i) {
            this.next();
        }
    }

    @Override
    public long sum(int items) throws IOException {
        long sum = 0L;
        for (int i = 0; i < items; ++i) {
            sum += this.next();
        }
        return sum;
    }

    @Override
    public long next() throws IOException {
        return LongDecode.readDwrfLong(this.input, this.orcTypeKind, this.signed, this.usesVInt);
    }

    @Override
    public void nextIntVector(int items, int[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        for (int i = 0; i < items; ++i) {
            vector[i] = Math.toIntExact(this.next());
        }
    }

    @Override
    public void nextIntVector(int items, int[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = Math.toIntExact(this.next());
        }
    }

    @Override
    public void nextLongVector(int items, long[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        for (int i = 0; i < items; ++i) {
            vector[i] = this.next();
        }
    }

    @Override
    public void nextLongVector(int items, long[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.next();
        }
    }

    @Override
    public void nextLongVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeLong(builder, this.next());
        }
    }

    @Override
    public void nextLongVector(Type type, int items, BlockBuilder builder, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, this.next());
        }
    }
}

