/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DoubleOutputStream
implements ValueOutputStream<DoubleStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<DoubleStreamCheckpoint> checkpoints = new ArrayList<DoubleStreamCheckpoint>();
    private boolean closed;

    public DoubleOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeDouble(double value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeDouble(value);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DoubleStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<DoubleStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public Optional<Stream> writeDataStreams(int column, SliceOutput outputStream) {
        Preconditions.checkState((boolean)this.closed);
        int length = this.buffer.writeDataTo(outputStream);
        return Optional.of(new Stream(column, Stream.StreamKind.DATA, length, false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.size();
    }

    @Override
    public long getRetainedBytes() {
        return INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

