/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class ByteOutputStream
implements ValueOutputStream<ByteStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteOutputStream.class).instanceSize();
    private static final int MIN_REPEAT_SIZE = 3;
    private static final int UNMATCHABLE_VALUE = Integer.MAX_VALUE;
    private final OrcOutputBuffer buffer;
    private final List<ByteStreamCheckpoint> checkpoints = new ArrayList<ByteStreamCheckpoint>();
    private final byte[] sequenceBuffer = new byte[128];
    private int size;
    private int runCount;
    private int lastValue = Integer.MAX_VALUE;
    private boolean closed;

    public ByteOutputStream(CompressionKind compression, int bufferSize) {
        this(new OrcOutputBuffer(compression, bufferSize));
    }

    public ByteOutputStream(OrcOutputBuffer buffer) {
        this.buffer = buffer;
    }

    public void writeByte(byte value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.size == this.sequenceBuffer.length) {
            this.flushSequence();
        }
        if (value == this.lastValue) {
            ++this.runCount;
        } else {
            if (this.runCount >= 3) {
                this.flushSequence();
            }
            this.runCount = 1;
        }
        this.sequenceBuffer[this.size] = value;
        ++this.size;
        if (this.runCount == 3 && this.size > 3) {
            this.size -= 3;
            this.runCount = 0;
            this.flushSequence();
            this.runCount = 3;
            this.size = 3;
        }
        this.lastValue = value;
    }

    private void flushSequence() {
        if (this.size == 0) {
            return;
        }
        if (this.runCount >= 3) {
            this.buffer.writeByte(this.runCount - 3);
            this.buffer.writeByte(this.lastValue);
        } else {
            this.buffer.writeByte(-this.size);
            for (int i = 0; i < this.size; ++i) {
                this.buffer.writeByte(this.sequenceBuffer[i]);
            }
        }
        this.size = 0;
        this.runCount = 0;
        this.lastValue = Integer.MAX_VALUE;
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new ByteStreamCheckpoint(this.size, this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
        this.flushSequence();
    }

    @Override
    public List<ByteStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public Optional<Stream> writeDataStreams(int column, SliceOutput outputStream) {
        Preconditions.checkState((boolean)this.closed);
        int length = this.buffer.writeDataTo(outputStream);
        return Optional.of(new Stream(column, Stream.StreamKind.DATA, length, false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.size() + this.size;
    }

    @Override
    public long getRetainedBytes() {
        return (long)(INSTANCE_SIZE + this.buffer.getRetainedSize()) + SizeOf.sizeOf((byte[])this.sequenceBuffer);
    }

    @Override
    public void reset() {
        this.size = 0;
        this.runCount = 0;
        this.lastValue = Integer.MAX_VALUE;
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

