/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StringStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private long nonNullValueCount;
    private Slice minimum;
    private Slice maximum;

    public long getNonNullValueCount() {
        return this.nonNullValueCount;
    }

    @Override
    public void addValue(Slice value) {
        Objects.requireNonNull(value, "value is null");
        ++this.nonNullValueCount;
        if (this.minimum == null) {
            this.minimum = value;
            this.maximum = value;
        } else if (value.compareTo(this.minimum) <= 0) {
            this.minimum = value;
        } else if (value.compareTo(this.maximum) >= 0) {
            this.maximum = value;
        }
    }

    private void addStringStatistics(long valueCount, StringStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.addValue(value.getMin());
        this.addValue(value.getMax());
    }

    private Optional<StringStatistics> buildStringStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new StringStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        return new ColumnStatistics(this.nonNullValueCount, null, null, null, this.buildStringStatistics().orElse(null), null, null, null);
    }

    public static Optional<StringStatistics> mergeStringStatistics(List<ColumnStatistics> stats) {
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            StringStatistics partialStatistics = columnStatistics.getStringStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            stringStatisticsBuilder.addStringStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return stringStatisticsBuilder.buildStringStatistics();
    }
}

