/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Objects;

public class StringStatistics
implements RangeStatistics<Slice> {
    private final Slice minimum;
    private final Slice maximum;

    public StringStatistics(Slice minimum, Slice maximum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum.compareTo(maximum) <= 0 ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public Slice getMin() {
        return this.minimum;
    }

    @Override
    public Slice getMax() {
        return this.maximum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringStatistics that = (StringStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.minimum.toStringUtf8()).add("max", (Object)this.maximum.toStringUtf8()).toString();
    }
}

