/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LongDecimalStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private BigDecimal minimum;
    private BigDecimal maximum;

    public void addValue(BigDecimal value) {
        Objects.requireNonNull(value, "value is null");
        ++this.nonNullValueCount;
        if (this.minimum == null) {
            this.minimum = value;
            this.maximum = value;
        } else {
            this.minimum = this.minimum.min(value);
            this.maximum = this.maximum.max(value);
        }
    }

    private void addDecimalStatistics(long valueCount, DecimalStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        if (this.minimum == null) {
            this.minimum = value.getMin();
            this.maximum = value.getMax();
        } else {
            this.minimum = this.minimum.min(value.getMin());
            this.maximum = this.maximum.max(value.getMax());
        }
    }

    private Optional<DecimalStatistics> buildDecimalStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new DecimalStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        return new ColumnStatistics(this.nonNullValueCount, null, null, null, null, null, this.buildDecimalStatistics().orElse(null), null);
    }

    public static Optional<DecimalStatistics> mergeDecimalStatistics(List<ColumnStatistics> stats) {
        LongDecimalStatisticsBuilder decimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DecimalStatistics partialStatistics = columnStatistics.getDecimalStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            decimalStatisticsBuilder.addDecimalStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return decimalStatisticsBuilder.buildDecimalStatistics();
    }
}

