/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class IntegerStatistics
implements RangeStatistics<Long> {
    private final Long minimum;
    private final Long maximum;

    public IntegerStatistics(Long minimum, Long maximum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public Long getMin() {
        return this.minimum;
    }

    @Override
    public Long getMax() {
        return this.maximum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerStatistics that = (IntegerStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.minimum).add("max", (Object)this.maximum).toString();
    }
}

