/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DoubleStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private boolean hasNan;
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;

    public void addValue(double value) {
        ++this.nonNullValueCount;
        if (Double.isNaN(value)) {
            this.hasNan = true;
        } else {
            this.minimum = Math.min(value, this.minimum);
            this.maximum = Math.max(value, this.maximum);
        }
    }

    private void addDoubleStatistics(long valueCount, DoubleStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
    }

    private Optional<DoubleStatistics> buildDoubleStatistics() {
        if (this.nonNullValueCount == 0L || this.hasNan) {
            return Optional.empty();
        }
        return Optional.of(new DoubleStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        return new ColumnStatistics(this.nonNullValueCount, null, null, this.buildDoubleStatistics().orElse(null), null, null, null, null);
    }

    public static Optional<DoubleStatistics> mergeDoubleStatistics(List<ColumnStatistics> stats) {
        DoubleStatisticsBuilder doubleStatisticsBuilder = new DoubleStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DoubleStatistics partialStatistics = columnStatistics.getDoubleStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            doubleStatisticsBuilder.addDoubleStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return doubleStatisticsBuilder.buildDoubleStatistics();
    }
}

