/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcMetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriters;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class OrcWriter
implements Closeable {
    private static final int COMPRESSION_BLOCK_SIZE = 262144;
    public static final DataSize DEFAULT_STRIPE_MAX_SIZE = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    public static final int DEFAULT_STRIPE_MIN_ROW_COUNT = 100000;
    public static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    public static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    public static final DataSize DEFAULT_DICTIONARY_MEMORY_MAX_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    static final String PRESTO_ORC_WRITER_VERSION_METADATA_KEY = "presto.writer.version";
    static final String PRESTO_ORC_WRITER_VERSION;
    private final SliceOutput output;
    private final List<Type> types;
    private final CompressionKind compression;
    private final int stripeMaxBytes;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final Map<String, String> userMetadata;
    private final MetadataWriter metadataWriter;
    private final DateTimeZone hiveStorageTimeZone;
    private final List<ClosedStripe> closedStripes = new ArrayList<ClosedStripe>();
    private final List<OrcType> orcTypes;
    private final List<ColumnWriter> columnWriters;
    private final DictionaryCompressionOptimizer dictionaryCompressionOptimizer;
    private long stripeStartOffset;
    private int stripeRowCount;
    private int rowGroupRowCount;
    private int bufferedBytes;
    private int retainedBytes;
    private boolean closed;
    @Nullable
    private OrcWriteValidation.OrcWriteValidationBuilder validationBuilder;

    public static OrcWriter createOrcWriter(SliceOutput output, List<String> columnNames, List<Type> types, CompressionKind compression, DataSize stripeMaxBytes, int stripeMinRowCount, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMemoryMaxBytes, Map<String, String> userMetadata, DateTimeZone hiveStorageTimeZone, boolean validate) {
        return new OrcWriter(output, columnNames, types, compression, stripeMaxBytes, stripeMinRowCount, stripeMaxRowCount, rowGroupMaxRowCount, dictionaryMemoryMaxBytes, userMetadata, new OrcMetadataWriter(), false, hiveStorageTimeZone, validate);
    }

    public static OrcWriter createDwrfWriter(SliceOutput output, List<String> columnNames, List<Type> types, CompressionKind compression, DataSize stripeMaxBytes, int stripeMinRowCount, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMemoryMaxBytes, Map<String, String> userMetadata, DateTimeZone hiveStorageTimeZone, boolean validate) {
        return new OrcWriter(output, columnNames, types, compression, stripeMaxBytes, stripeMinRowCount, stripeMaxRowCount, rowGroupMaxRowCount, dictionaryMemoryMaxBytes, userMetadata, new DwrfMetadataWriter(), true, hiveStorageTimeZone, validate);
    }

    private OrcWriter(SliceOutput output, List<String> columnNames, List<Type> types, CompressionKind compression, DataSize stripeMaxBytes, int stripeMinRowCount, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMemoryMaxBytes, Map<String, String> userMetadata, MetadataWriter metadataWriter, boolean isDwrf, DateTimeZone hiveStorageTimeZone, boolean validate) {
        this.validationBuilder = validate ? new OrcWriteValidation.OrcWriteValidationBuilder(types) : null;
        this.output = Objects.requireNonNull(output, "output is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.recordValidation(validation -> validation.setCompression(compression));
        this.stripeMaxBytes = Math.toIntExact(Objects.requireNonNull(stripeMaxBytes, "stripeMaxSize is null").toBytes());
        Preconditions.checkArgument((stripeMinRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMinRowCount must be at least 1");
        Preconditions.checkArgument((stripeMaxRowCount >= stripeMinRowCount ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be greater than stripeMinRowCount");
        this.stripeMaxRowCount = stripeMaxRowCount;
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.recordValidation(validation -> validation.setRowGroupMaxRowCount(rowGroupMaxRowCount));
        this.userMetadata = ImmutableMap.builder().putAll(Objects.requireNonNull(userMetadata, "userMetadata is null")).put((Object)PRESTO_ORC_WRITER_VERSION_METADATA_KEY, (Object)PRESTO_ORC_WRITER_VERSION).build();
        this.metadataWriter = new CompressedMetadataWriter(Objects.requireNonNull(metadataWriter, "metadataWriter is null"), compression, 262144);
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.orcTypes = OrcType.createOrcRowType(0, columnNames, types);
        this.recordValidation(validation -> validation.setColumnNames(columnNames));
        OrcType rootType = this.orcTypes.get(0);
        Preconditions.checkArgument((rootType.getFieldCount() == types.size() ? 1 : 0) != 0);
        ImmutableList.Builder columnWriters = ImmutableList.builder();
        ImmutableSet.Builder sliceColumnWriters = ImmutableSet.builder();
        for (int fieldId = 0; fieldId < types.size(); ++fieldId) {
            int fieldColumnIndex = rootType.getFieldTypeIndex(fieldId);
            Type fieldType = types.get(fieldId);
            ColumnWriter columnWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, this.orcTypes, fieldType, compression, 262144, isDwrf, hiveStorageTimeZone);
            columnWriters.add((Object)columnWriter);
            if (columnWriter instanceof SliceDictionaryColumnWriter) {
                sliceColumnWriters.add((Object)((SliceDictionaryColumnWriter)columnWriter));
                continue;
            }
            for (ColumnWriter nestedColumnWriter : columnWriter.getNestedColumnWriters()) {
                if (!(nestedColumnWriter instanceof SliceDictionaryColumnWriter)) continue;
                sliceColumnWriters.add((Object)((SliceDictionaryColumnWriter)nestedColumnWriter));
            }
        }
        this.columnWriters = columnWriters.build();
        this.dictionaryCompressionOptimizer = new DictionaryCompressionOptimizer((Set<? extends DictionaryCompressionOptimizer.DictionaryColumn>)sliceColumnWriters.build(), Math.toIntExact(stripeMaxBytes.toBytes()), stripeMinRowCount, stripeMaxRowCount, Math.toIntExact(Objects.requireNonNull(dictionaryMemoryMaxBytes, "dictionaryMemoryMaxSize is null").toBytes()));
        output.writeBytes(PostScript.MAGIC);
        this.stripeStartOffset = output.size();
        for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            this.recordValidation(validation -> validation.addMetadataProperty((String)entry.getKey(), Slices.utf8Slice((String)((String)entry.getValue()))));
        }
    }

    public int getBufferedBytes() {
        return this.bufferedBytes;
    }

    public long getRetainedBytes() {
        return this.retainedBytes;
    }

    public void write(Page page) throws IOException {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkArgument((page.getChannelCount() == this.columnWriters.size() ? 1 : 0) != 0);
        if (this.validationBuilder != null) {
            this.validationBuilder.addPage(page);
        }
        while (page != null) {
            Page chunk;
            if (this.rowGroupRowCount + page.getPositionCount() > this.rowGroupMaxRowCount || this.stripeRowCount + page.getPositionCount() > this.stripeMaxRowCount) {
                int chunkRows = Integer.min(this.rowGroupMaxRowCount - this.rowGroupRowCount, this.stripeMaxRowCount - this.stripeRowCount);
                chunk = page.getRegion(0, chunkRows);
                page = page.getRegion(chunkRows, page.getPositionCount() - chunkRows);
            } else {
                chunk = page;
                page = null;
            }
            this.writeChunk(chunk);
        }
    }

    private void writeChunk(Page chunk) throws IOException {
        if (this.rowGroupRowCount == 0) {
            this.columnWriters.forEach(ColumnWriter::beginRowGroup);
        }
        this.bufferedBytes = 0;
        for (int channel = 0; channel < chunk.getChannelCount(); ++channel) {
            ColumnWriter writer = this.columnWriters.get(channel);
            writer.writeBlock(chunk.getBlock(channel));
            this.bufferedBytes = (int)((long)this.bufferedBytes + writer.getBufferedBytes());
        }
        this.rowGroupRowCount += chunk.getPositionCount();
        Preconditions.checkState((this.rowGroupRowCount <= this.rowGroupMaxRowCount ? 1 : 0) != 0);
        this.stripeRowCount += chunk.getPositionCount();
        if (this.rowGroupRowCount == this.rowGroupMaxRowCount) {
            this.finishRowGroup();
        }
        this.dictionaryCompressionOptimizer.optimize(this.bufferedBytes, this.stripeRowCount);
        this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
        if (this.stripeRowCount == this.stripeMaxRowCount || this.bufferedBytes > this.stripeMaxBytes || this.dictionaryCompressionOptimizer.isFull()) {
            this.writeStripe();
        }
        this.retainedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum());
    }

    private void finishRowGroup() {
        HashMap columnStatistics = new HashMap();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.finishRowGroup()));
        this.recordValidation(validation -> validation.addRowGroupStatistics(columnStatistics));
        this.rowGroupRowCount = 0;
    }

    private void writeStripe() throws IOException {
        if (this.stripeRowCount == 0) {
            return;
        }
        this.recordValidation(validation -> validation.addStripe(this.stripeRowCount));
        if (this.rowGroupRowCount > 0) {
            this.finishRowGroup();
        }
        this.dictionaryCompressionOptimizer.finalOptimize();
        this.columnWriters.forEach(ColumnWriter::close);
        ArrayList<Stream> allStreams = new ArrayList<Stream>();
        long indexLength = 0L;
        for (ColumnWriter columnWriter2 : this.columnWriters) {
            List<Stream> indexStreams = columnWriter2.writeIndexStreams(this.output, this.metadataWriter);
            allStreams.addAll(indexStreams);
            indexLength += indexStreams.stream().mapToInt(Stream::getLength).asLongStream().sum();
        }
        long dataLength = 0L;
        for (ColumnWriter columnWriter3 : this.columnWriters) {
            List<Stream> dataStreams = columnWriter3.writeDataStreams(this.output);
            allStreams.addAll(dataStreams);
            dataLength += dataStreams.stream().mapToInt(Stream::getLength).asLongStream().sum();
        }
        HashMap<Integer, ColumnEncoding> columnEncodings = new HashMap<Integer, ColumnEncoding>();
        this.columnWriters.forEach(columnWriter -> columnEncodings.putAll(columnWriter.getColumnEncodings()));
        HashMap<Integer, ColumnStatistics> columnStatistics = new HashMap<Integer, ColumnStatistics>();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.getColumnStripeStatistics()));
        columnEncodings.put(0, new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0));
        columnStatistics.put(0, new ColumnStatistics(Long.valueOf(this.stripeRowCount), null, null, null, null, null, null, null));
        StripeFooter stripeFooter = new StripeFooter(allStreams, OrcWriter.toDenseList(columnEncodings, this.orcTypes.size()));
        int footerLength = this.metadataWriter.writeStripeFooter(this.output, stripeFooter);
        StripeStatistics statistics = new StripeStatistics(OrcWriter.toDenseList(columnStatistics, this.orcTypes.size()));
        this.recordValidation(validation -> validation.addStripeStatistics(this.stripeStartOffset, statistics));
        StripeInformation stripeInformation = new StripeInformation(this.stripeRowCount, this.stripeStartOffset, indexLength, dataLength, footerLength);
        this.closedStripes.add(new ClosedStripe(stripeInformation, statistics));
        this.columnWriters.forEach(ColumnWriter::reset);
        this.dictionaryCompressionOptimizer.reset();
        this.rowGroupRowCount = 0;
        this.stripeRowCount = 0;
        this.stripeStartOffset = this.output.size();
        this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeStripe();
        Metadata metadata = new Metadata(this.closedStripes.stream().map(ClosedStripe::getStatistics).collect(Collectors.toList()));
        int metadataLength = this.metadataWriter.writeMetadata(this.output, metadata);
        long numberOfRows = this.closedStripes.stream().mapToLong(stripe -> stripe.getStripeInformation().getNumberOfRows()).sum();
        List<ColumnStatistics> fileStats = OrcWriter.toFileStats(this.closedStripes.stream().map(ClosedStripe::getStatistics).map(StripeStatistics::getColumnStatistics).collect(Collectors.toList()));
        this.recordValidation(validation -> validation.setFileStatistics(fileStats));
        Map<String, Slice> userMetadata = this.userMetadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Slices.utf8Slice((String)((String)entry.getValue()))));
        Footer footer = new Footer(numberOfRows, this.rowGroupMaxRowCount, this.closedStripes.stream().map(ClosedStripe::getStripeInformation).collect(Collectors.toList()), this.orcTypes, fileStats, userMetadata);
        int footerLength = this.metadataWriter.writeFooter(this.output, footer);
        this.recordValidation(validation -> validation.setVersion(this.metadataWriter.getOrcMetadataVersion()));
        int postScriptLength = this.metadataWriter.writePostscript(this.output, footerLength, metadataLength, this.compression, 262144);
        this.output.writeByte(postScriptLength);
        this.output.close();
    }

    private void recordValidation(Consumer<OrcWriteValidation.OrcWriteValidationBuilder> task) {
        if (this.validationBuilder != null) {
            task.accept(this.validationBuilder);
        }
    }

    public void validate(OrcDataSource input) throws OrcCorruptionException {
        Preconditions.checkState((this.validationBuilder != null ? 1 : 0) != 0, (Object)"validation is not enabled");
        OrcReader.validateFile(this.validationBuilder.build(), input, this.types, this.hiveStorageTimeZone, this.metadataWriter.getMetadataReader());
    }

    private static <T> List<T> toDenseList(Map<Integer, T> data, int expectedSize) {
        Preconditions.checkArgument((data.size() == expectedSize ? 1 : 0) != 0);
        ArrayList<T> list = new ArrayList<T>(expectedSize);
        for (int i = 0; i < expectedSize; ++i) {
            list.add(data.get(i));
        }
        return ImmutableList.copyOf(list);
    }

    private static List<ColumnStatistics> toFileStats(List<List<ColumnStatistics>> stripes) {
        if (stripes.isEmpty()) {
            return ImmutableList.of();
        }
        int columnCount = stripes.get(0).size();
        Preconditions.checkArgument((boolean)stripes.stream().allMatch(stripe -> columnCount == stripe.size()));
        ImmutableList.Builder fileStats = ImmutableList.builder();
        int i = 0;
        while (i < columnCount) {
            int column = i++;
            fileStats.add((Object)ColumnStatistics.mergeColumnStatistics(stripes.stream().map(stripe -> (ColumnStatistics)stripe.get(column)).collect(Collectors.toList())));
        }
        return fileStats.build();
    }

    static {
        String version = OrcWriter.class.getPackage().getImplementationVersion();
        PRESTO_ORC_WRITER_VERSION = version == null ? "UNKNOWN" : version;
    }

    private static class ClosedStripe {
        private final StripeInformation stripeInformation;
        private final StripeStatistics statistics;

        public ClosedStripe(StripeInformation stripeInformation, StripeStatistics statistics) {
            this.stripeInformation = Objects.requireNonNull(stripeInformation, "stripeInformation is null");
            this.statistics = Objects.requireNonNull(statistics, "stripeStatistics is null");
        }

        public StripeInformation getStripeInformation() {
            return this.stripeInformation;
        }

        public StripeStatistics getStatistics() {
            return this.statistics;
        }
    }
}

