/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.snappy.SnappyDecompressor;
import java.util.Objects;

class OrcSnappyDecompressor
implements OrcDecompressor {
    private final OrcDataSourceId orcDataSourceId;
    private final int maxBufferSize;
    private final SnappyDecompressor decompressor = new SnappyDecompressor();

    public OrcSnappyDecompressor(OrcDataSourceId orcDataSourceId, int maxBufferSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        try {
            int uncompressedLength = SnappyDecompressor.getUncompressedLength((byte[])input, (int)offset);
            if (uncompressedLength > this.maxBufferSize) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Snappy requires buffer (%s) larger than max size (%s)", uncompressedLength, this.maxBufferSize);
            }
            byte[] buffer = output.initialize(uncompressedLength + 8);
            return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
        }
        catch (MalformedInputException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid compressed stream", new Object[0]);
        }
    }

    public String toString() {
        return "snappy";
    }
}

