/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcSnappyDecompressor;
import com.facebook.presto.orc.OrcZlibDecompressor;
import com.facebook.presto.orc.OrcZstdDecompressor;
import com.facebook.presto.orc.metadata.CompressionKind;
import java.util.Optional;

public interface OrcDecompressor {
    public static Optional<OrcDecompressor> createOrcDecompressor(OrcDataSourceId orcDataSourceId, CompressionKind compression, int bufferSize) throws OrcCorruptionException {
        switch (compression) {
            case NONE: {
                return Optional.empty();
            }
            case ZLIB: {
                return Optional.of(new OrcZlibDecompressor(orcDataSourceId, bufferSize));
            }
            case SNAPPY: {
                return Optional.of(new OrcSnappyDecompressor(orcDataSourceId, bufferSize));
            }
            case ZSTD: {
                return Optional.of(new OrcZstdDecompressor(orcDataSourceId, bufferSize));
            }
        }
        throw new OrcCorruptionException(orcDataSourceId, "Unknown compression type: " + (Object)((Object)compression));
    }

    public int decompress(byte[] var1, int var2, int var3, OutputBuffer var4) throws OrcCorruptionException;

    public static interface OutputBuffer {
        public byte[] initialize(int var1);

        public byte[] grow(int var1);
    }
}

