/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.AbstractOrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileOrcDataSource
extends AbstractOrcDataSource {
    private final RandomAccessFile input;

    public FileOrcDataSource(File path, DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize) throws FileNotFoundException {
        super(new OrcDataSourceId(path.getPath()), path.length(), maxMergeDistance, maxReadSize, streamBufferSize);
        this.input = new RandomAccessFile(path, "r");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
    }
}

