/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PostScript {
    private final List<Integer> version;
    private final long footerLength;
    private final long metadataLength;
    private final CompressionKind compression;
    private final long compressionBlockSize;
    private final HiveWriterVersion hiveWriterVersion;

    public PostScript(List<Integer> version, long footerLength, long metadataLength, CompressionKind compression, long compressionBlockSize, HiveWriterVersion hiveWriterVersion) {
        this.version = ImmutableList.copyOf((Collection)Objects.requireNonNull(version, "version is null"));
        this.footerLength = footerLength;
        this.metadataLength = metadataLength;
        this.compression = Objects.requireNonNull(compression, "compressionKind is null");
        this.compressionBlockSize = compressionBlockSize;
        this.hiveWriterVersion = Objects.requireNonNull(hiveWriterVersion, "hiveWriterVersion is null");
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public long getFooterLength() {
        return this.footerLength;
    }

    public long getMetadataLength() {
        return this.metadataLength;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public long getCompressionBlockSize() {
        return this.compressionBlockSize;
    }

    public HiveWriterVersion getHiveWriterVersion() {
        return this.hiveWriterVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("footerLength", this.footerLength).add("metadataLength", this.metadataLength).add("compressionKind", (Object)this.compression).add("compressionBlockSize", this.compressionBlockSize).add("hiveWriterVersion", (Object)this.hiveWriterVersion).toString();
    }

    public static enum HiveWriterVersion {
        ORIGINAL,
        ORC_HIVE_8732;

    }
}

