/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV1Checkpoint;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;

public class LongInputStreamV1
implements LongInputStream {
    private static final int MAX_LITERAL_SIZE = 128;
    private final OrcInputStream input;
    private final boolean signed;
    private final long[] literals = new long[128];
    private int numLiterals;
    private int delta;
    private int used;
    private boolean repeat;
    private long lastReadInputCheckpoint;

    public LongInputStreamV1(OrcInputStream input, boolean signed) {
        this.input = input;
        this.signed = signed;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readValues() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException("Read past end of RLE integer from %s", this.input);
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new OrcCorruptionException("End of stream in RLE Integer from %s", this.input);
            }
            this.delta = (byte)this.delta;
            this.literals[0] = LongDecode.readVInt(this.signed, this.input);
        } else {
            this.numLiterals = 256 - control;
            this.used = 0;
            this.repeat = false;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = LongDecode.readVInt(this.signed, this.input);
            }
        }
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    @Override
    public Class<? extends LongStreamV1Checkpoint> getCheckpointType() {
        return LongStreamV1Checkpoint.class;
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamV1Checkpoint v1Checkpoint = (LongStreamV1Checkpoint)checkpoint;
        if (this.lastReadInputCheckpoint == v1Checkpoint.getInputStreamCheckpoint() && v1Checkpoint.getOffset() <= this.numLiterals) {
            this.used = v1Checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(v1Checkpoint.getInputStreamCheckpoint());
            this.numLiterals = 0;
            this.used = 0;
            this.skip(v1Checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }

    @Override
    public long sum(int items) throws IOException {
        long sum = 0L;
        for (int i = 0; i < items; ++i) {
            sum += this.next();
        }
        return sum;
    }

    @Override
    public void nextLongVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeLong(builder, this.next());
        }
    }

    @Override
    public void nextLongVector(Type type, int items, BlockBuilder builder, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, this.next());
        }
    }

    @Override
    public void nextLongVector(int items, long[] vector) throws IOException {
        for (int i = 0; i < items; ++i) {
            vector[i] = this.next();
        }
    }

    @Override
    public void nextLongVector(int items, long[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.next();
        }
    }

    @Override
    public void nextIntVector(int items, int[] vector) throws IOException {
        for (int i = 0; i < items; ++i) {
            vector[i] = Math.toIntExact(this.next());
        }
    }

    @Override
    public void nextIntVector(int items, int[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = Math.toIntExact(this.next());
        }
    }
}

