/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DecimalStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private boolean[] nullVector = new boolean[0];
    private long[] scaleVector = new long[0];
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    @Nonnull
    private InputStreamSource<DecimalInputStream> decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    @Nullable
    private DecimalInputStream decimalStream;
    @Nonnull
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream scaleStream;
    private boolean rowGroupOpen;

    public DecimalStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        DecimalType decimalType = (DecimalType)type;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        this.allocateVectors();
        BlockBuilder builder = decimalType.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.decimalStream == null) {
                throw new OrcCorruptionException("Value is not null but decimal stream is not present");
            }
            if (this.scaleStream == null) {
                throw new OrcCorruptionException("Value is not null but scale stream is not present");
            }
            Arrays.fill(this.nullVector, false);
            this.scaleStream.nextLongVector(this.nextBatchSize, this.scaleVector);
            if (decimalType.isShort()) {
                this.decimalStream.nextShortDecimalVector(this.nextBatchSize, builder, decimalType, this.scaleVector);
            } else {
                this.decimalStream.nextLongDecimalVector(this.nextBatchSize, builder, decimalType, this.scaleVector);
            }
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException("Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException("Value is not null but scale stream is not present");
                }
                this.scaleStream.nextLongVector(this.nextBatchSize, this.scaleVector, this.nullVector);
                if (decimalType.isShort()) {
                    this.decimalStream.nextShortDecimalVector(this.nextBatchSize, builder, decimalType, this.scaleVector, this.nullVector);
                } else {
                    this.decimalStream.nextLongDecimalVector(this.nextBatchSize, builder, decimalType, this.scaleVector, this.nullVector);
                }
            } else {
                for (int i = 0; i < this.nextBatchSize; ++i) {
                    builder.appendNull();
                }
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException("Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException("Value is not null but scale stream is not present");
                }
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    private void allocateVectors() {
        if (this.nullVector.length < this.nextBatchSize) {
            this.nullVector = new boolean[this.nextBatchSize];
            this.scaleVector = new long[this.nextBatchSize];
        }
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.decimalStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

