/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.zstd.ZstdDecompressor;
import com.google.common.base.Preconditions;

class OrcZstdDecompressor
implements OrcDecompressor {
    private final int maxBufferSize;
    private final ZstdDecompressor decompressor = new ZstdDecompressor();

    public OrcZstdDecompressor(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        int uncompressedLength = (int)ZstdDecompressor.getDecompressedSize(input, offset, length);
        Preconditions.checkArgument((uncompressedLength <= this.maxBufferSize ? 1 : 0) != 0, (String)"Zstd requires buffer (%s) larger than max size (%s)", (int)uncompressedLength, (int)this.maxBufferSize);
        byte[] buffer = output.initialize(uncompressedLength);
        return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
    }

    public String toString() {
        return "zstd";
    }
}

