/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDecompressor;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class OrcZlibDecompressor
implements OrcDecompressor {
    private static final int EXPECTED_COMPRESSION_RATIO = 5;
    private final int maxBufferSize;

    public OrcZlibDecompressor(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        Inflater inflater = new Inflater(true);
        try {
            int uncompressedLength;
            block7: {
                int oldBufferSize;
                inflater.setInput(input, offset, length);
                byte[] buffer = output.initialize(Math.min(length * 5, this.maxBufferSize));
                uncompressedLength = 0;
                do {
                    uncompressedLength += inflater.inflate(buffer, uncompressedLength, buffer.length - uncompressedLength);
                    if (inflater.finished() || buffer.length >= this.maxBufferSize) break block7;
                    oldBufferSize = buffer.length;
                } while ((buffer = output.grow(Math.min(buffer.length * 2, this.maxBufferSize))).length > oldBufferSize);
                throw new IllegalStateException(String.format("Buffer failed to grow. Old size %d, current size %d", oldBufferSize, buffer.length));
            }
            if (!inflater.finished()) {
                throw new OrcCorruptionException("Could not decompress all input (output buffer too small?)");
            }
            int n = uncompressedLength;
            return n;
        }
        catch (DataFormatException e) {
            throw new OrcCorruptionException(e, "Invalid compressed stream", new Object[0]);
        }
        finally {
            inflater.end();
        }
    }

    public String toString() {
        return "zlib";
    }
}

