/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueStream;
import java.io.IOException;
import java.math.BigInteger;

public class DecimalStream
implements ValueStream<DecimalStreamCheckpoint> {
    private final OrcInputStream input;

    public DecimalStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<? extends DecimalStreamCheckpoint> getCheckpointType() {
        return DecimalStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DecimalStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    public BigInteger nextBigInteger() throws IOException {
        boolean isNegative;
        long b;
        BigInteger result = BigInteger.ZERO;
        long work = 0L;
        int offset = 0;
        do {
            if ((b = (long)this.input.read()) == -1L) {
                throw new OrcCorruptionException("Reading BigInteger past EOF from " + this.input);
            }
            if (offset >= 126 && (offset != 126 || (work |= (0x7FL & b) << offset % 63) > 3L)) {
                throw new OrcCorruptionException("Decimal exceeds 128 bits");
            }
            if ((offset += 7) == 63) {
                result = BigInteger.valueOf(work);
                work = 0L;
                continue;
            }
            if (offset % 63 != 0) continue;
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset - 63));
            work = 0L;
        } while (b >= 128L);
        if (work != 0L) {
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset / 63 * 63));
        }
        if (isNegative = result.testBit(0)) {
            result = result.add(BigInteger.ONE);
            result = result.negate();
        }
        result = result.shiftRight(1);
        return result;
    }

    public void nextBigIntegerVector(int items, BigInteger[] vector) throws IOException {
        for (int i = 0; i < items; ++i) {
            vector[i] = this.nextBigInteger();
        }
    }

    public void nextBigIntegerVector(int items, BigInteger[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.nextBigInteger();
        }
    }

    public long nextLong() throws IOException {
        boolean isNegative;
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)this.input.read()) == -1L) {
                throw new OrcCorruptionException("Reading BigInteger past EOF from " + this.input);
            }
            long work = 0x7FL & b;
            if (offset >= 63 && (offset != 63 || work > 1L)) {
                throw new OrcCorruptionException("Decimal does not fit long (invalid table schema?)");
            }
            result |= work << offset;
            offset += 7;
        } while (b >= 128L);
        boolean bl = isNegative = (result & 1L) != 0L;
        if (isNegative) {
            ++result;
            result = -result;
            result >>= 1;
            result |= Long.MIN_VALUE;
        } else {
            result >>= 1;
            result &= Long.MAX_VALUE;
        }
        return result;
    }

    public void nextLongVector(int items, long[] vector) throws IOException {
        for (int i = 0; i < items; ++i) {
            vector[i] = this.nextLong();
        }
    }

    public void nextLongVector(int items, long[] vector, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.nextLong();
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items-- > 0L) {
            int b;
            do {
                if ((b = this.input.read()) != -1) continue;
                throw new OrcCorruptionException("Reading BigInteger past EOF from " + this.input);
            } while (b >= 128);
        }
    }
}

