/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class StructStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final StreamReader[] structFields;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private boolean rowGroupOpen;

    public StructStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        this.structFields = new StreamReader[nestedStreams.size()];
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            this.structFields[i] = StreamReaders.createStreamReader(nestedStream, hiveStorageTimeZone);
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            for (StreamReader structField : this.structFields) {
                structField.prepareNextRead(this.readOffset);
            }
        }
        List typeParameters = type.getTypeParameters();
        boolean[] nullVector = new boolean[this.nextBatchSize];
        Block[] blocks = new Block[typeParameters.size()];
        if (this.presentStream == null) {
            for (int i = 0; i < typeParameters.size(); ++i) {
                StreamReader structField = this.structFields[i];
                structField.prepareNextRead(this.nextBatchSize);
                blocks[i] = structField.readBlock((Type)typeParameters.get(i));
            }
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    StreamReader structField = this.structFields[i];
                    structField.prepareNextRead(this.nextBatchSize - nullValues);
                    blocks[i] = structField.readBlock((Type)typeParameters.get(i));
                }
            } else {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i] = ((Type)typeParameters.get(i)).createBlockBuilder(new BlockBuilderStatus(), 0).build();
                }
            }
        }
        int[] offsets = new int[this.nextBatchSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            int length = nullVector[i - 1] ? 0 : typeParameters.size();
            offsets[i] = offsets[i - 1] + length;
        }
        InterleavedBlock interleavedBlock = new InterleavedBlock(blocks);
        ArrayBlock arrayBlock = new ArrayBlock(this.nextBatchSize, nullVector, offsets, (Block)interleavedBlock);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return arrayBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (StreamReader structField : this.structFields) {
            structField.startStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (StreamReader structField : this.structFields) {
            structField.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

