/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class ListStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final StreamReader elementStreamReader;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<LongStream> lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream lengthStream;
    private boolean rowGroupOpen;

    public ListStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.elementStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(0), hiveStorageTimeZone);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        Block elements;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                long elementSkipSize = this.lengthStream.sum(this.readOffset);
                this.elementStreamReader.prepareNextRead(Math.toIntExact(elementSkipSize));
            }
        }
        int[] lengthVector = new int[this.nextBatchSize];
        boolean[] nullVector = new boolean[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            this.lengthStream.nextIntVector(this.nextBatchSize, lengthVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, lengthVector, nullVector);
            }
        }
        int[] offsets = new int[this.nextBatchSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            int length = lengthVector[i - 1];
            offsets[i] = offsets[i - 1] + length;
        }
        Type elementType = (Type)type.getTypeParameters().get(0);
        int elementCount = offsets[offsets.length - 1];
        if (elementCount > 0) {
            this.elementStreamReader.prepareNextRead(elementCount);
            elements = this.elementStreamReader.readBlock(elementType);
        } else {
            elements = elementType.createBlockBuilder(new BlockBuilderStatus(), 0).build();
        }
        ArrayBlock arrayBlock = new ArrayBlock(this.nextBatchSize, nullVector, offsets, elements);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return arrayBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.elementStreamReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.lengthStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.elementStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

