/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.FloatStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;

public class FloatStream
implements ValueStream<FloatStreamCheckpoint> {
    private final OrcInputStream input;
    private final byte[] buffer = new byte[4];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public FloatStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<FloatStreamCheckpoint> getCheckpointType() {
        return FloatStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(FloatStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 4L;
        OrcStreamUtils.skipFully(this.input, length);
    }

    public float next() throws IOException {
        OrcStreamUtils.readFully(this.input, this.buffer, 0, 4);
        return this.slice.getFloat(0);
    }

    public void nextVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeDouble(builder, (double)this.next());
        }
    }

    public void nextVector(Type type, long items, BlockBuilder builder, boolean[] isNull) throws IOException {
        int i = 0;
        while ((long)i < items) {
            if (isNull[i]) {
                builder.appendNull();
            } else {
                type.writeDouble(builder, (double)this.next());
            }
            ++i;
        }
    }
}

