/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.BooleanStreamReader;
import com.facebook.presto.orc.reader.ByteStreamReader;
import com.facebook.presto.orc.reader.DecimalStreamReader;
import com.facebook.presto.orc.reader.DoubleStreamReader;
import com.facebook.presto.orc.reader.FloatStreamReader;
import com.facebook.presto.orc.reader.ListStreamReader;
import com.facebook.presto.orc.reader.LongStreamReader;
import com.facebook.presto.orc.reader.MapStreamReader;
import com.facebook.presto.orc.reader.SliceStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StructStreamReader;
import com.facebook.presto.orc.reader.TimestampStreamReader;
import org.joda.time.DateTimeZone;

public final class StreamReaders {
    private StreamReaders() {
    }

    public static StreamReader createStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanStreamReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteStreamReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongStreamReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatStreamReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleStreamReader(streamDescriptor);
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: {
                return new SliceStreamReader(streamDescriptor);
            }
            case TIMESTAMP: {
                return new TimestampStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case LIST: {
                return new ListStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case STRUCT: {
                return new StructStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case MAP: {
                return new MapStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case UNION: 
            case DECIMAL: {
                return new DecimalStreamReader(streamDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

