/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDirectStreamReader
implements StreamReader {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private boolean[] isNullVector = new boolean[0];
    @Nonnull
    private StreamSource<LongStream> lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream lengthStream;
    private int[] lengthVector = new int[0];
    @Nonnull
    private StreamSource<ByteArrayStream> dataByteSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
    @Nullable
    private ByteArrayStream dataStream;
    private boolean rowGroupOpen;

    public SliceDirectStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but length stream is not present");
                }
                long dataSkipSize = this.lengthStream.sum(this.readOffset);
                if (dataSkipSize > 0L) {
                    if (this.dataStream == null) {
                        throw new OrcCorruptionException("Value is not null but data stream is not present");
                    }
                    this.dataStream.skip(dataSkipSize);
                }
            }
        }
        if (this.isNullVector.length < this.nextBatchSize) {
            this.isNullVector = new boolean[this.nextBatchSize];
        }
        if (this.lengthVector.length < this.nextBatchSize) {
            this.lengthVector = new int[this.nextBatchSize];
        }
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException("Value is not null but length stream is not present");
            }
            Arrays.fill(this.isNullVector, false);
            this.lengthStream.nextIntVector(this.nextBatchSize, this.lengthVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but length stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, this.lengthVector, this.isNullVector);
            }
        }
        int totalLength = 0;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.isNullVector[i]) continue;
            totalLength += this.lengthVector[i];
        }
        byte[] data = EMPTY_BYTE_ARRAY;
        if (totalLength > 0) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            data = this.dataStream.next(totalLength);
        }
        Slice[] sliceVector = new Slice[this.nextBatchSize];
        int offset = 0;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.isNullVector[i]) continue;
            int length = this.lengthVector[i];
            Slice value = Slices.wrappedBuffer((byte[])data, (int)offset, (int)length);
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            sliceVector[i] = value;
            offset += length;
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new SliceArrayBlock(sliceVector.length, sliceVector);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.dataByteSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.lengthStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class);
        this.dataByteSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

