/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.metadata.BooleanStatistics;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.RangeStatistics;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TupleDomainOrcPredicate<C>
implements OrcPredicate {
    private final TupleDomain<C> effectivePredicate;
    private final List<ColumnReference<C>> columnReferences;

    public TupleDomainOrcPredicate(TupleDomain<C> effectivePredicate, List<ColumnReference<C>> columnReferences) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columnReferences = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnReferences, "columnReferences is null"));
    }

    @Override
    public boolean matches(long numberOfRows, Map<Integer, ColumnStatistics> statisticsByColumnIndex) {
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (ColumnReference<C> columnReference : this.columnReferences) {
            ColumnStatistics columnStatistics = statisticsByColumnIndex.get(columnReference.getOrdinal());
            Domain domain = columnStatistics == null ? Domain.all((Type)columnReference.getType()) : TupleDomainOrcPredicate.getDomain(columnReference.getType(), numberOfRows, columnStatistics);
            domains.put(columnReference.getColumn(), (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, ColumnStatistics columnStatistics) {
        boolean hasNullValue;
        if (rowCount == 0L) {
            return Domain.none((Type)type);
        }
        if (columnStatistics == null) {
            return Domain.all((Type)type);
        }
        if (columnStatistics.hasNumberOfValues() && columnStatistics.getNumberOfValues() == 0L) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = columnStatistics.getNumberOfValues() != rowCount;
        if (type.getJavaType() == Boolean.TYPE && columnStatistics.getBooleanStatistics() != null) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = columnStatistics.getBooleanStatistics();
            boolean hasTrueValues = booleanStatistics.getTrueValueCount() != 0L;
            boolean bl2 = hasFalseValues = columnStatistics.getNumberOfValues() != booleanStatistics.getTrueValueCount();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)BooleanType.BOOLEAN);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if (type.getTypeSignature().getBase().equals("date") && columnStatistics.getDateStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDateStatistics(), value -> (long)value);
            }
            if (type.getJavaType() == Long.TYPE && columnStatistics.getIntegerStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getIntegerStatistics());
            }
            if (type.getJavaType() == Double.TYPE && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics());
            }
            if (type.getJavaType() == Slice.class && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics());
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<T> rangeStatistics) {
        return TupleDomainOrcPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    public static class ColumnReference<C> {
        private final C column;
        private final int ordinal;
        private final Type type;

        public ColumnReference(C column, int ordinal, Type type) {
            this.column = Objects.requireNonNull(column, "column is null");
            Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal is negative");
            this.ordinal = ordinal;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public C getColumn() {
            return this.column;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("ordinal", this.ordinal).add("type", (Object)this.type).toString();
        }
    }
}

