/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.ObjectVector;
import com.facebook.presto.orc.Vector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Objects;

public class SliceVector
implements Vector {
    public Slice[] vector;
    public int[] ids;
    public boolean dictionary;
    public boolean[] isNull;

    public SliceVector() {
    }

    public SliceVector(int length) {
        if (length > 1024) {
            throw new IllegalArgumentException("length greater than max vector length");
        }
        this.vector = new Slice[length];
        this.dictionary = false;
    }

    public void initialize(int length) {
        if (length > 1024) {
            throw new IllegalArgumentException("length greater than max vector length");
        }
        this.vector = new Slice[length];
        this.dictionary = false;
    }

    public void setDictionary(Slice[] dictionary, int[] ids, boolean[] isNullVector) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        Objects.requireNonNull(isNullVector, "isNullVector is null");
        Preconditions.checkArgument((ids.length == isNullVector.length ? 1 : 0) != 0);
        this.vector = dictionary;
        this.ids = ids;
        this.isNull = isNullVector;
        this.dictionary = true;
    }

    @Override
    @VisibleForTesting
    public ObjectVector toObjectVector(int size) {
        int length = this.dictionary ? this.ids.length : this.vector.length;
        ObjectVector objectVector = new ObjectVector(length);
        for (int i = 0; i < size; ++i) {
            Slice objectAtPosition = this.getSliceAtPosition(i);
            objectVector.vector[i] = objectAtPosition;
        }
        return objectVector;
    }

    public Slice getSliceAtPosition(int position) {
        if (this.dictionary) {
            return this.isNull[position] ? null : this.vector[this.ids[position]];
        }
        return this.vector[position];
    }
}

