/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.StripeStatistics;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class OrcRecordReader {
    private final OrcDataSource orcDataSource;
    private final StreamReader[] streamReaders;
    private final long totalRowCount;
    private final long splitLength;
    private final Set<Integer> presentColumns;
    private long currentPosition;
    private long currentStripePosition;
    private int currentBatchSize;
    private final List<StripeInformation> stripes;
    private final StripeReader stripeReader;
    private int currentStripe = -1;
    private final long fileRowCount;
    private final List<Long> stripeFilePositions;
    private long filePosition;
    private Iterator<RowGroup> rowGroups = ImmutableList.of().iterator();
    private long currentGroupRowCount;
    private long nextRowInGroup;

    public OrcRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, List<OrcType> types, CompressionKind compressionKind, int bufferSize, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, MetadataReader metadataReader) throws IOException {
        Preconditions.checkNotNull(includedColumns, (Object)"includedColumns is null");
        Preconditions.checkNotNull((Object)predicate, (Object)"predicate is null");
        Preconditions.checkNotNull(fileStripes, (Object)"fileStripes is null");
        Preconditions.checkNotNull(stripeStats, (Object)"stripeStats is null");
        Preconditions.checkNotNull((Object)orcDataSource, (Object)"orcDataSource is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)((Object)compressionKind), (Object)"compressionKind is null");
        Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null");
        ImmutableSet.Builder presentColumns = ImmutableSet.builder();
        ImmutableMap.Builder presentColumnsAndTypes = ImmutableMap.builder();
        OrcType root = types.get(0);
        for (Map.Entry<Integer, Type> entry : includedColumns.entrySet()) {
            if (entry.getKey() >= root.getFieldCount()) continue;
            presentColumns.add((Object)entry.getKey());
            presentColumnsAndTypes.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.presentColumns = presentColumns.build();
        this.orcDataSource = orcDataSource;
        this.splitLength = splitLength;
        Preconditions.checkArgument((rowsInRowGroup > 0 ? 1 : 0) != 0, (Object)"rowsInRowGroup must be greater than zero");
        ArrayList<StripeInfo> stripeInfos = new ArrayList<StripeInfo>();
        for (int i = 0; i < fileStripes.size(); ++i) {
            Optional<StripeStatistics> stats = Optional.empty();
            if (stripeStats.size() == fileStripes.size()) {
                stats = Optional.of(stripeStats.get(i));
            }
            stripeInfos.add(new StripeInfo(fileStripes.get(i), stats));
        }
        Collections.sort(stripeInfos, Comparator.comparingLong(info -> info.getStripe().getOffset()));
        long totalRowCount = 0L;
        long fileRowCount = 0L;
        ImmutableList.Builder stripes = ImmutableList.builder();
        ImmutableList.Builder stripeFilePositions = ImmutableList.builder();
        if (predicate.matches(numberOfRows, OrcRecordReader.getStatisticsByColumnOrdinal(root, fileStats))) {
            for (StripeInfo info2 : stripeInfos) {
                StripeInformation stripe = info2.getStripe();
                if (OrcRecordReader.splitContainsStripe(splitOffset, splitLength, stripe) && OrcRecordReader.isStripeIncluded(root, stripe, info2.getStats(), predicate)) {
                    stripes.add((Object)stripe);
                    stripeFilePositions.add((Object)fileRowCount);
                    totalRowCount += (long)stripe.getNumberOfRows();
                }
                fileRowCount += (long)stripe.getNumberOfRows();
            }
        }
        this.totalRowCount = totalRowCount;
        this.stripes = stripes.build();
        this.stripeFilePositions = stripeFilePositions.build();
        this.fileRowCount = stripeInfos.stream().map(StripeInfo::getStripe).mapToLong(StripeInformation::getNumberOfRows).sum();
        this.stripeReader = new StripeReader(orcDataSource, compressionKind, types, bufferSize, this.presentColumns, rowsInRowGroup, predicate, metadataReader);
        this.streamReaders = OrcRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, (Map<Integer, Type>)presentColumnsAndTypes.build());
    }

    private static boolean splitContainsStripe(long splitOffset, long splitLength, StripeInformation stripe) {
        long splitEndOffset = splitOffset + splitLength;
        return splitOffset <= stripe.getOffset() && stripe.getOffset() < splitEndOffset;
    }

    private static boolean isStripeIncluded(OrcType rootStructType, StripeInformation stripe, Optional<StripeStatistics> stripeStats, OrcPredicate predicate) {
        if (!stripeStats.isPresent()) {
            return true;
        }
        return predicate.matches(stripe.getNumberOfRows(), OrcRecordReader.getStatisticsByColumnOrdinal(rootStructType, stripeStats.get().getColumnStatistics()));
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long getFileRowCount() {
        return this.fileRowCount;
    }

    public long getReaderPosition() {
        return this.currentPosition;
    }

    public long getReaderRowCount() {
        return this.totalRowCount;
    }

    public float getProgress() {
        return (float)this.currentPosition / (float)this.totalRowCount;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    public void close() throws IOException {
        this.orcDataSource.close();
    }

    public boolean isColumnPresent(int hiveColumnIndex) {
        return this.presentColumns.contains(hiveColumnIndex);
    }

    public int nextBatch() throws IOException {
        this.filePosition += (long)this.currentBatchSize;
        this.currentPosition += (long)this.currentBatchSize;
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            this.filePosition = this.fileRowCount;
            this.currentPosition = this.totalRowCount;
            return -1;
        }
        this.currentBatchSize = Ints.checkedCast((long)Math.min(1024L, this.currentGroupRowCount - this.nextRowInGroup));
        for (StreamReader column : this.streamReaders) {
            if (column == null) continue;
            column.prepareNextRead(this.currentBatchSize);
        }
        this.nextRowInGroup += (long)this.currentBatchSize;
        return this.currentBatchSize;
    }

    public void readVector(int columnIndex, Object vector) throws IOException {
        this.streamReaders[columnIndex].readBatch(vector);
    }

    public void readVector(Type type, int columnIndex, Object vector) throws IOException {
        this.streamReaders[columnIndex].readBatch(type, vector);
    }

    public StreamReader getStreamReader(int index) {
        Preconditions.checkArgument((index < this.streamReaders.length ? 1 : 0) != 0, (Object)"index does not exist");
        return this.streamReaders[index];
    }

    private boolean advanceToNextRowGroup() throws IOException {
        this.nextRowInGroup = 0L;
        while (!this.rowGroups.hasNext() && this.currentStripe < this.stripes.size()) {
            this.advanceToNextStripe();
        }
        if (!this.rowGroups.hasNext()) {
            this.currentGroupRowCount = 0L;
            return false;
        }
        RowGroup currentRowGroup = this.rowGroups.next();
        this.currentGroupRowCount = currentRowGroup.getRowCount();
        this.currentPosition = this.currentStripePosition + currentRowGroup.getRowOffset();
        this.filePosition = this.stripeFilePositions.get(this.currentStripe) + currentRowGroup.getRowOffset();
        StreamSources rowGroupStreamSources = currentRowGroup.getStreamSources();
        for (StreamReader column : this.streamReaders) {
            if (column == null) continue;
            column.startRowGroup(rowGroupStreamSources);
        }
        return true;
    }

    private void advanceToNextStripe() throws IOException {
        StripeInformation stripeInformation;
        Stripe stripe;
        ++this.currentStripe;
        if (this.currentStripe >= this.stripes.size()) {
            return;
        }
        if (this.currentStripe > 0) {
            this.currentStripePosition += (long)this.stripes.get(this.currentStripe - 1).getNumberOfRows();
        }
        if ((stripe = this.stripeReader.readStripe(stripeInformation = this.stripes.get(this.currentStripe))) != null) {
            StreamSources dictionaryStreamSources = stripe.getDictionaryStreamSources();
            List<ColumnEncoding> columnEncodings = stripe.getColumnEncodings();
            for (StreamReader column : this.streamReaders) {
                if (column == null) continue;
                column.startStripe(dictionaryStreamSources, columnEncodings);
            }
            this.rowGroups = stripe.getRowGroups().iterator();
        } else {
            this.rowGroups = ImmutableList.of().iterator();
        }
    }

    private static StreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, Map<Integer, Type> includedColumns) {
        List<StreamDescriptor> streamDescriptors = OrcRecordReader.createStreamDescriptor("", "", 0, types, orcDataSource).getNestedStreams();
        OrcType rowType = types.get(0);
        StreamReader[] streamReaders = new StreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            if (!includedColumns.containsKey(columnId)) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            streamReaders[columnId] = StreamReaders.createStreamReader(streamDescriptor, includedColumns.get(columnId), hiveStorageTimeZone);
        }
        return streamReaders;
    }

    private static StreamDescriptor createStreamDescriptor(String parentStreamName, String fieldName, int typeId, List<OrcType> types, OrcDataSource dataSource) {
        OrcType type = types.get(typeId);
        if (!fieldName.isEmpty()) {
            parentStreamName = parentStreamName + "." + fieldName;
        }
        ImmutableList.Builder nestedStreams = ImmutableList.builder();
        if (type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            for (int i = 0; i < type.getFieldCount(); ++i) {
                nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, type.getFieldName(i), type.getFieldTypeIndex(i), types, dataSource));
            }
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "item", type.getFieldTypeIndex(0), types, dataSource));
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "key", type.getFieldTypeIndex(0), types, dataSource));
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "value", type.getFieldTypeIndex(1), types, dataSource));
        }
        return new StreamDescriptor(parentStreamName, typeId, fieldName, type.getOrcTypeKind(), dataSource, (List<StreamDescriptor>)nestedStreams.build());
    }

    private static Map<Integer, ColumnStatistics> getStatisticsByColumnOrdinal(OrcType rootStructType, List<ColumnStatistics> fileStats) {
        Preconditions.checkNotNull((Object)rootStructType, (Object)"rootStructType is null");
        Preconditions.checkArgument((rootStructType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0);
        Preconditions.checkNotNull(fileStats, (Object)"fileStats is null");
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < rootStructType.getFieldCount(); ++ordinal) {
            ColumnStatistics element = fileStats.get(rootStructType.getFieldTypeIndex(ordinal));
            if (element == null) continue;
            statistics.put((Object)ordinal, (Object)element);
        }
        return statistics.build();
    }

    private static class StripeInfo {
        private final StripeInformation stripe;
        private final Optional<StripeStatistics> stats;

        public StripeInfo(StripeInformation stripe, Optional<StripeStatistics> stats) {
            this.stripe = (StripeInformation)Preconditions.checkNotNull((Object)stripe, (Object)"stripe is null");
            this.stats = (Optional)Preconditions.checkNotNull(stats, (Object)"metadata is null");
        }

        public StripeInformation getStripe() {
            return this.stripe;
        }

        public Optional<StripeStatistics> getStats() {
            return this.stats;
        }
    }
}

