/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class OrcType {
    private final OrcTypeKind orcTypeKind;
    private final List<Integer> fieldTypeIndexes;
    private final List<String> fieldNames;

    public OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames) {
        this.orcTypeKind = (OrcTypeKind)((Object)Preconditions.checkNotNull((Object)((Object)orcTypeKind), (Object)"typeKind is null"));
        this.fieldTypeIndexes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fieldTypeIndexes, (Object)"fieldTypeIndexes is null")));
        if (fieldNames == null || fieldNames.isEmpty() && !fieldTypeIndexes.isEmpty()) {
            this.fieldNames = null;
        } else {
            this.fieldNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fieldNames, (Object)"fieldNames is null")));
            Preconditions.checkArgument((fieldNames.size() == fieldTypeIndexes.size() ? 1 : 0) != 0, (Object)"fieldNames and fieldTypeIndexes have different sizes");
        }
    }

    public OrcTypeKind getOrcTypeKind() {
        return this.orcTypeKind;
    }

    public int getFieldCount() {
        return this.fieldTypeIndexes.size();
    }

    public int getFieldTypeIndex(int field) {
        return this.fieldTypeIndexes.get(field);
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcTypeKind", (Object)this.orcTypeKind).add("fieldTypeIndexes", this.fieldTypeIndexes).add("fieldNames", this.fieldNames).toString();
    }

    public static enum OrcTypeKind {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        VARCHAR,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP,
        LIST,
        MAP,
        STRUCT,
        UNION;

    }
}

