/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongDictionaryBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private BooleanStream inDictionaryStream;
    @Nullable
    private LongStream dataStream;
    @Nonnull
    private long[] dictionary = new long[0];

    public LongDictionaryBlockReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                builder.appendNull();
                return true;
            }
            return false;
        }
        BigintType.BIGINT.writeLong(builder, this.nextValue());
        return true;
    }

    private long nextValue() throws IOException {
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        long value = this.dataStream.next();
        if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) {
            value = this.dictionary[(int)value];
        }
        return value;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (this.inDictionaryStream != null) {
            this.inDictionaryStream.skip(skipSize);
        }
        if (skipSize > 0) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            this.dataStream.skip(skipSize);
        }
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        int dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        if (dictionarySize > 0) {
            LongStream dictionaryStream;
            if (this.dictionary.length < dictionarySize) {
                this.dictionary = new long[dictionarySize];
            }
            if ((dictionaryStream = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongStream.class).openStream()) == null) {
                throw new OrcCorruptionException("Dictionary is not empty but data stream is not present");
            }
            dictionaryStream.nextLongVector(dictionarySize, this.dictionary);
        }
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.inDictionaryStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

