/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Objects;

public final class DiskRange {
    private final long offset;
    private final int length;

    public DiskRange(long offset, int length) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset is negative");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length is negative");
        this.offset = offset;
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getEnd() {
        return this.offset + (long)this.length;
    }

    public boolean contains(DiskRange diskRange) {
        return this.offset <= diskRange.getOffset() && diskRange.getEnd() <= this.getEnd();
    }

    public DiskRange span(DiskRange otherDiskRange) {
        Preconditions.checkNotNull((Object)otherDiskRange, (Object)"otherDiskRange is null");
        long start = Math.min(this.offset, otherDiskRange.getOffset());
        long end = Math.max(this.getEnd(), otherDiskRange.getEnd());
        return new DiskRange(start, Ints.checkedCast((long)(end - start)));
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiskRange other = (DiskRange)obj;
        return Objects.equals(this.offset, other.offset) && Objects.equals(this.length, other.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("length", this.length).toString();
    }
}

