/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.ValueStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class StreamSources {
    private final Map<StreamId, StreamSource<?>> streamSources;

    public StreamSources(Map<StreamId, StreamSource<?>> streamSources) {
        this.streamSources = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(streamSources, (Object)"streamSources is null")));
    }

    @Nonnull
    public <S extends ValueStream<?>> StreamSource<S> getStreamSource(StreamDescriptor streamDescriptor, Stream.StreamKind streamKind, Class<S> streamType) {
        Preconditions.checkNotNull((Object)streamDescriptor, (Object)"streamDescriptor is null");
        Preconditions.checkNotNull(streamType, (Object)"streamType is null");
        StreamSource<Object> streamSource = this.streamSources.get(new StreamId(streamDescriptor.getStreamId(), streamKind));
        if (streamSource == null) {
            streamSource = MissingStreamSource.missingStreamSource(streamType);
        }
        Preconditions.checkArgument((boolean)streamType.isAssignableFrom(streamSource.getStreamType()), (String)"%s must be of type %s, not %s", (Object[])new Object[]{streamDescriptor, streamType.getName(), streamSource.getStreamType().getName()});
        return streamSource;
    }
}

