/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.block.SliceDictionaryBlockReader;
import com.facebook.presto.orc.block.SliceDirectBlockReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

public class SliceBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    private final SliceDirectBlockReader directReader;
    private final SliceDictionaryBlockReader dictionaryReader;
    private BlockReader currentReader;

    public SliceBlockReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.directReader = new SliceDirectBlockReader(streamDescriptor);
        this.dictionaryReader = new SliceDictionaryBlockReader(streamDescriptor);
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        return this.currentReader.readNextValueInto(builder, skipNull);
    }

    @Override
    public void skip(int skipSize) throws IOException {
        this.currentReader.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind columnEncodingKind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncodingKind();
        if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)columnEncodingKind));
        }
        this.currentReader.openStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.currentReader.openRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

