/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.block.BlockReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class ListBlockReader
implements BlockReader {
    private final DynamicSliceOutput out = new DynamicSliceOutput(1024);
    private final StreamDescriptor streamDescriptor;
    private final boolean checkForNulls;
    private final BlockReader elementReader;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream lengthStream;

    public ListBlockReader(StreamDescriptor streamDescriptor, boolean checkForNulls, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.checkForNulls = checkForNulls;
        this.elementReader = BlockReaders.createBlockReader(streamDescriptor.getNestedStreams().get(0), true, hiveStorageTimeZone);
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        this.out.reset();
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                ((BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null")).appendNull();
                return true;
            }
            return false;
        }
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        long length = this.lengthStream.next();
        BlockBuilder currentBuilder = VarbinaryType.VARBINARY.createBlockBuilder(new BlockBuilderStatus(), Ints.checkedCast((long)length));
        int i = 0;
        while ((long)i < length) {
            this.elementReader.readNextValueInto(currentBuilder, false);
            ++i;
        }
        currentBuilder.getEncoding().writeBlock((SliceOutput)this.out, currentBuilder.build());
        if (builder != null) {
            VarbinaryType.VARBINARY.writeSlice(builder, this.out.copySlice());
        }
        return true;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        long elementSkipSize = this.lengthStream.sum(skipSize);
        this.elementReader.skip(Ints.checkedCast((long)elementSkipSize));
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.lengthStream = null;
        this.elementReader.openStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        if (this.checkForNulls) {
            this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        }
        this.lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream();
        this.elementReader.openRowGroup(dataStreamSources);
    }

    @Override
    public Slice toSlice() {
        return this.out.copySlice();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

