/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDirectBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream lengthStream;
    @Nullable
    private ByteArrayStream dataStream;
    @Nonnull
    private byte[] data = new byte[1024];

    public SliceDirectBlockReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                builder.appendNull();
                return true;
            }
            return false;
        }
        int length = this.bufferNextValue();
        VarcharType.VARCHAR.writeSlice(builder, Slices.wrappedBuffer((byte[])this.data, (int)0, (int)length));
        return true;
    }

    private int bufferNextValue() throws IOException {
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        int length = Ints.checkedCast((long)this.lengthStream.next());
        if (this.data.length < length) {
            this.data = new byte[length];
        }
        if (length > 0) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Length is not zero but data stream is not present");
            }
            this.dataStream.next(length, this.data);
        }
        return length;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        long dataSkipSize = this.lengthStream.sum(skipSize);
        if (dataSkipSize == 0L) {
            return;
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Length is not zero but data stream is not present");
        }
        this.dataStream.skip(Ints.checkedCast((long)dataSkipSize));
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

