/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.oracle;

import com.facebook.airlift.configuration.Config;
import java.math.RoundingMode;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class OracleConfig {
    private boolean synonymsEnabled;
    private int varcharMaxSize = 4000;
    private int timestampDefaultPrecision = 6;
    private int numberDefaultScale = 10;
    private RoundingMode numberRoundingMode = RoundingMode.HALF_UP;

    @NotNull
    public boolean isSynonymsEnabled() {
        return this.synonymsEnabled;
    }

    @Config(value="oracle.synonyms.enabled")
    public OracleConfig setSynonymsEnabled(boolean enabled) {
        this.synonymsEnabled = enabled;
        return this;
    }

    @Min(value=0L)
    @Max(value=38L)
    public @Min(value=0L) @Max(value=38L) int getNumberDefaultScale() {
        return this.numberDefaultScale;
    }

    @Config(value="oracle.number.default-scale")
    public OracleConfig setNumberDefaultScale(int numberDefaultScale) {
        this.numberDefaultScale = numberDefaultScale;
        return this;
    }

    @NotNull
    public RoundingMode getNumberRoundingMode() {
        return this.numberRoundingMode;
    }

    @Config(value="oracle.number.rounding-mode")
    public OracleConfig setNumberRoundingMode(RoundingMode numberRoundingMode) {
        this.numberRoundingMode = numberRoundingMode;
        return this;
    }

    @Min(value=4000L)
    public @Min(value=4000L) int getVarcharMaxSize() {
        return this.varcharMaxSize;
    }

    @Config(value="oracle.varchar.max-size")
    public OracleConfig setVarcharMaxSize(int varcharMaxSize) {
        this.varcharMaxSize = varcharMaxSize;
        return this;
    }

    @Min(value=0L)
    @Max(value=9L)
    public @Min(value=0L) @Max(value=9L) int getTimestampDefaultPrecision() {
        return this.timestampDefaultPrecision;
    }

    @Config(value="oracle.timestamp.precision")
    public OracleConfig setTimestampDefaultPrecision(int timestampDefaultPrecision) {
        this.timestampDefaultPrecision = timestampDefaultPrecision;
        return this;
    }
}

