/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.opentelemetry;

import com.facebook.presto.opentelemetry.OpenTelemetryBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenTelemetryTracer
implements com.facebook.presto.spi.tracing.Tracer {
    private static String currentContextPropagator = "b3_single_header";
    private static OpenTelemetry openTelemetry = OpenTelemetryBuilder.build(currentContextPropagator);
    private final Tracer openTelemetryTracer;
    private final String traceToken;
    private final Span parentSpan;
    private final Context parentContext;
    public final Map<String, Span> spanMap = new ConcurrentHashMap<String, Span>();
    public final Map<String, Span> recorderSpanMap = new LinkedHashMap<String, Span>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenTelemetryTracer(String traceToken, String contextPropagator, String propagatedContext, String baggage) {
        TextMapGetter<String> trivialGetter = new TextMapGetter<String>(){

            public String get(String carrier, String key) {
                return carrier;
            }

            public Iterable<String> keys(String carrier) {
                return Arrays.asList(this.get(carrier, null));
            }
        };
        if (contextPropagator != null && !contextPropagator.equals(currentContextPropagator)) {
            openTelemetry = OpenTelemetryBuilder.build(contextPropagator);
            currentContextPropagator = contextPropagator;
        }
        this.openTelemetryTracer = openTelemetry.getTracer("com.facebook.presto");
        this.traceToken = traceToken;
        if (propagatedContext != null) {
            Context extractedContext = openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)propagatedContext, (TextMapGetter)trivialGetter);
            Context contextWithBaggage = W3CBaggagePropagator.getInstance().extract(extractedContext, (Object)baggage, (TextMapGetter)trivialGetter);
            try (Scope ignored = contextWithBaggage.makeCurrent();){
                this.parentSpan = this.createParentSpan();
            }
            this.parentContext = contextWithBaggage;
        } else {
            this.parentSpan = this.createParentSpan();
            this.parentContext = Context.current();
        }
        this.addBaggageToSpanAttributes(this.parentSpan);
        Map<String, Span> map = this.recorderSpanMap;
        synchronized (map) {
            this.recorderSpanMap.put("Trace start", this.parentSpan);
        }
    }

    private void addBaggageToSpanAttributes(Span span) {
        Baggage baggage = Baggage.fromContext((Context)this.parentContext);
        baggage.forEach((s, baggageEntry) -> span.setAttribute(s, baggageEntry.getValue()));
    }

    private Span createParentSpan() {
        Span parentSpan = this.openTelemetryTracer.spanBuilder("Trace start").startSpan();
        parentSpan.setAttribute("trace_id", this.traceToken);
        return parentSpan;
    }

    private void endUnendedBlocks() {
        ArrayList<String> blocks = new ArrayList<String>(this.spanMap.keySet());
        for (String currBlock : blocks) {
            this.endBlock(currBlock, "");
        }
    }

    public void addPoint(String annotation) {
        this.parentSpan.addEvent(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlock(String blockName, String annotation) {
        if (this.spanMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Duplicated block inserted: " + blockName);
        }
        Span span = this.openTelemetryTracer.spanBuilder(blockName).setParent(Context.current().with((ImplicitContextKeyed)this.parentSpan)).startSpan();
        span.addEvent(annotation);
        this.addBaggageToSpanAttributes(span);
        this.spanMap.put(blockName, span);
        Map<String, Span> map = this.recorderSpanMap;
        synchronized (map) {
            this.recorderSpanMap.put(blockName, span);
        }
    }

    public void addPointToBlock(String blockName, String annotation) {
        if (!this.spanMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Adding point to non-existing block: " + blockName);
        }
        this.spanMap.get(blockName).addEvent(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBlock(String blockName, String annotation) {
        if (!this.spanMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Trying to end a non-existing block: " + blockName);
        }
        this.spanMap.remove(blockName);
        Map<String, Span> map = this.recorderSpanMap;
        synchronized (map) {
            Span span = this.recorderSpanMap.get(blockName);
            span.addEvent(annotation);
            span.end();
        }
    }

    public void endTrace(String annotation) {
        this.parentSpan.addEvent(annotation);
        this.endUnendedBlocks();
        this.parentSpan.end();
    }

    public String getTracerId() {
        if (this.traceToken != null) {
            return this.traceToken;
        }
        return "com.facebook.presto";
    }
}

