/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;

public final class OpenTelemetryBuilder {
    private OpenTelemetryBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    private static TextMapPropagator getPropagatorInstance(String contextPropagator) {
        Object propagator = contextPropagator.equals("w3c") ? W3CTraceContextPropagator.getInstance() : (contextPropagator.equals("b3_single_header") ? B3Propagator.injectingSingleHeader() : B3Propagator.injectingMultiHeaders());
        return propagator;
    }

    public static OpenTelemetry build(String contextPropagator) {
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)"presto")));
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)OtlpGrpcSpanExporter.builder().setEndpoint(System.getenv("OTEL_EXPORTER_OTLP_ENDPOINT")).build()).build()).setResource(resource).build();
        return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)OpenTelemetryBuilder.getPropagatorInstance(contextPropagator))).buildAndRegisterGlobal();
    }
}

