/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.opentelemetry;

import com.facebook.presto.opentelemetry.OpenTelemetryErrorCode;
import com.facebook.presto.opentelemetry.OpenTelemetryTracer;
import com.facebook.presto.opentelemetry.OpenTelemetryTracerHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.spi.tracing.TracerHandle;
import com.facebook.presto.spi.tracing.TracerProvider;
import com.google.inject.Inject;
import java.util.Map;
import java.util.function.Function;

public class OpenTelemetryTracerProvider
implements TracerProvider {
    @Inject
    public OpenTelemetryTracerProvider() {
    }

    public String getName() {
        return "Open telemetry tracer provider";
    }

    public String getTracerType() {
        return "otel";
    }

    public Function<Map<String, String>, TracerHandle> getHandleGenerator() {
        return headers -> {
            String contextPropagator = this.determineContextPropagationMode((Map<String, String>)headers);
            return new OpenTelemetryTracerHandle((String)headers.get("X-Presto-Trace-Token"), contextPropagator, OpenTelemetryTracerProvider.getPropagatedContextFromHeader(contextPropagator, headers), (String)headers.get("baggage"));
        };
    }

    public Tracer getNewTracer(TracerHandle handle) {
        OpenTelemetryTracerHandle tracerHandle = (OpenTelemetryTracerHandle)handle;
        return new OpenTelemetryTracer(tracerHandle.getTraceToken(), tracerHandle.getContextPropagator(), tracerHandle.getPropagatedContext(), tracerHandle.getBaggage());
    }

    private String determineContextPropagationMode(Map<String, String> headers) {
        if (headers.containsKey("b3")) {
            return "b3_single_header";
        }
        if (headers.containsKey("traceparent")) {
            throw new PrestoException((ErrorCodeSupplier)OpenTelemetryErrorCode.OPEN_TELEMETRY_CONTEXT_PROPAGATOR_ERROR, "Only b3 single header context propagation mode is currently supported.");
        }
        return null;
    }

    private static String getPropagatedContextFromHeader(String contextPropagator, Map<String, String> headers) {
        if (contextPropagator != null) {
            if (contextPropagator.equals("b3_single_header")) {
                return headers.get("b3");
            }
            if (contextPropagator.equals("w3c")) {
                return headers.get("traceparent");
            }
        }
        return null;
    }
}

