/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionHandleResolver;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class NativeFunctionHandle
extends SqlFunctionHandle {
    private final Signature signature;

    @JsonCreator
    public NativeFunctionHandle(@JsonProperty(value="signature") Signature signature) {
        super(new SqlFunctionId(signature.getName(), signature.getArgumentTypes()), "1");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.signature.getName().toString();
    }

    public FunctionKind getKind() {
        return this.signature.getKind();
    }

    public CatalogSchemaName getCatalogSchemaName() {
        return this.signature.getName().getCatalogSchemaName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NativeFunctionHandle that = (NativeFunctionHandle)((Object)o);
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public String toString() {
        return this.signature.toString();
    }

    public static class Resolver
    implements FunctionHandleResolver {
        public Class<? extends FunctionHandle> getFunctionHandleClass() {
            return NativeFunctionHandle.class;
        }
    }
}

