/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeSignatureUtils;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.sidecar.functionNamespace.FunctionDefinitionProvider;
import com.facebook.presto.sidecar.functionNamespace.NativeFunctionHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlFunctionSupplier;
import com.facebook.presto.spi.function.SqlInvokedAggregationFunctionImplementation;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;

public class NativeFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final Logger log = Logger.get(NativeFunctionNamespaceManager.class);
    private final Map<QualifiedObjectName, UserDefinedType> userDefinedTypes = new ConcurrentHashMap<QualifiedObjectName, UserDefinedType>();
    private final Map<SqlFunctionHandle, AggregationFunctionImplementation> aggregationImplementationByHandle = new ConcurrentHashMap<SqlFunctionHandle, AggregationFunctionImplementation>();
    private final FunctionDefinitionProvider functionDefinitionProvider;
    private final NodeManager nodeManager;
    private final Map<SqlFunctionId, SqlInvokedFunction> functions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedFunction>();
    private final Supplier<Map<SqlFunctionId, SqlInvokedFunction>> memoizedFunctionsSupplier;
    private final FunctionMetadataManager functionMetadataManager;
    private final LoadingCache<Signature, SqlFunctionSupplier> specializedFunctionKeyCache;

    @Inject
    public NativeFunctionNamespaceManager(@ServingCatalog String catalogName, SqlFunctionExecutors sqlFunctionExecutors, SqlInvokedFunctionNamespaceManagerConfig config, FunctionDefinitionProvider functionDefinitionProvider, NodeManager nodeManager, FunctionMetadataManager functionMetadataManager) {
        super(catalogName, sqlFunctionExecutors, config);
        this.functionDefinitionProvider = Objects.requireNonNull(functionDefinitionProvider, "functionDefinitionProvider is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.memoizedFunctionsSupplier = Suppliers.memoize(this::bootstrapNamespace);
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.specializedFunctionKeyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(this::doGetSpecializedFunctionKey));
    }

    private SqlFunctionSupplier doGetSpecializedFunctionKey(Signature signature) {
        return this.functionMetadataManager.getSpecializedFunctionKey(signature);
    }

    private synchronized Map<SqlFunctionId, SqlInvokedFunction> bootstrapNamespace() {
        this.functions.clear();
        UdfFunctionSignatureMap nativeFunctionSignatureMap = this.functionDefinitionProvider.getUdfDefinition(this.nodeManager);
        if (nativeFunctionSignatureMap == null || nativeFunctionSignatureMap.isEmpty()) {
            return ImmutableMap.of();
        }
        this.populateNamespaceManager(nativeFunctionSignatureMap);
        Preconditions.checkArgument((!this.functions.isEmpty() ? 1 : 0) != 0, (Object)"functions map is empty !");
        return Collections.unmodifiableMap(this.functions);
    }

    private synchronized void populateNamespaceManager(UdfFunctionSignatureMap udfFunctionSignatureMap) {
        Map udfSignatureMap = udfFunctionSignatureMap.getUDFSignatureMap();
        udfSignatureMap.forEach((name, metaInfoList) -> {
            List functions = (List)metaInfoList.stream().map(metaInfo -> this.createSqlInvokedFunction((String)name, (JsonBasedUdfFunctionMetadata)metaInfo)).collect(ImmutableList.toImmutableList());
            functions.forEach(this::createFunction);
        });
    }

    public final AggregationFunctionImplementation getAggregateFunctionImplementation(FunctionHandle functionHandle, TypeManager typeManager) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        SqlFunctionHandle sqlFunctionHandle = (SqlFunctionHandle)functionHandle;
        if (this.aggregationImplementationByHandle.containsKey(sqlFunctionHandle)) {
            return this.aggregationImplementationByHandle.get(sqlFunctionHandle);
        }
        if (functionHandle instanceof NativeFunctionHandle) {
            return this.processNativeFunctionHandle((NativeFunctionHandle)sqlFunctionHandle, typeManager);
        }
        return this.processSqlFunctionHandle(sqlFunctionHandle, typeManager);
    }

    private AggregationFunctionImplementation processNativeFunctionHandle(NativeFunctionHandle nativeFunctionHandle, TypeManager typeManager) {
        Signature signature = nativeFunctionHandle.getSignature();
        SqlFunction function = this.getSqlFunctionFromSignature(signature);
        SqlInvokedFunction sqlFunction = (SqlInvokedFunction)function;
        Preconditions.checkArgument((boolean)sqlFunction.getAggregationMetadata().isPresent(), (Object)"Need aggregationMetadata to get aggregation function implementation");
        AggregationFunctionMetadata aggregationMetadata = (AggregationFunctionMetadata)sqlFunction.getAggregationMetadata().get();
        TypeSignature intermediateType = aggregationMetadata.getIntermediateType();
        TypeSignature resolvedIntermediateType = TypeSignatureUtils.resolveIntermediateType((TypeSignature)intermediateType, (List)sqlFunction.getFunctionId().getArgumentTypes(), (List)signature.getArgumentTypes());
        List parameters = (List)signature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        this.aggregationImplementationByHandle.put(nativeFunctionHandle, (AggregationFunctionImplementation)new SqlInvokedAggregationFunctionImplementation(typeManager.getType(resolvedIntermediateType), typeManager.getType(signature.getReturnType()), aggregationMetadata.isOrderSensitive(), parameters));
        return this.aggregationImplementationByHandle.get((Object)nativeFunctionHandle);
    }

    private AggregationFunctionImplementation processSqlFunctionHandle(SqlFunctionHandle sqlFunctionHandle, TypeManager typeManager) {
        SqlFunctionId functionId = sqlFunctionHandle.getFunctionId();
        if (!this.memoizedFunctionsSupplier.get().containsKey(functionId)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' is missing from cache", functionId.getId()));
        }
        this.aggregationImplementationByHandle.put(sqlFunctionHandle, this.sqlInvokedFunctionToAggregationImplementation(this.memoizedFunctionsSupplier.get().get(functionId), typeManager));
        return this.aggregationImplementationByHandle.get(sqlFunctionHandle);
    }

    protected synchronized SqlInvokedFunction createSqlInvokedFunction(String functionName, JsonBasedUdfFunctionMetadata jsonBasedUdfFunctionMetaData) {
        Preconditions.checkState((boolean)jsonBasedUdfFunctionMetaData.getRoutineCharacteristics().getLanguage().equals((Object)RoutineCharacteristics.Language.CPP), (Object)"NativeFunctionNamespaceManager only supports CPP UDF");
        QualifiedObjectName qualifiedFunctionName = QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName(this.getCatalogName(), jsonBasedUdfFunctionMetaData.getSchema()), (String)functionName);
        List parameterNameList = jsonBasedUdfFunctionMetaData.getParamNames();
        List<TypeSignature> parameterTypeList = NativeFunctionNamespaceManager.convertApplicableTypeToVariable(jsonBasedUdfFunctionMetaData.getParamTypes());
        List typeVariableConstraintsList = jsonBasedUdfFunctionMetaData.getTypeVariableConstraints().isPresent() ? (List)jsonBasedUdfFunctionMetaData.getTypeVariableConstraints().get() : Collections.emptyList();
        List longVariableConstraintList = jsonBasedUdfFunctionMetaData.getLongVariableConstraints().isPresent() ? (List)jsonBasedUdfFunctionMetaData.getLongVariableConstraints().get() : Collections.emptyList();
        TypeSignature outputType = NativeFunctionNamespaceManager.convertApplicableTypeToVariable(jsonBasedUdfFunctionMetaData.getOutputType());
        ImmutableList.Builder parameterBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterNameList.size(); ++i) {
            parameterBuilder.add((Object)new Parameter((String)parameterNameList.get(i), parameterTypeList.get(i)));
        }
        Optional<AggregationFunctionMetadata> aggregationFunctionMetadata = jsonBasedUdfFunctionMetaData.getAggregateMetadata().map(metadata -> new AggregationFunctionMetadata(NativeFunctionNamespaceManager.convertApplicableTypeToVariable(metadata.getIntermediateType()), metadata.isOrderSensitive()));
        return new SqlInvokedFunction(qualifiedFunctionName, (List)parameterBuilder.build(), typeVariableConstraintsList, longVariableConstraintList, outputType, jsonBasedUdfFunctionMetaData.getDocString(), jsonBasedUdfFunctionMetaData.getRoutineCharacteristics(), "", jsonBasedUdfFunctionMetaData.getVariableArity(), FunctionVersion.notVersioned(), jsonBasedUdfFunctionMetaData.getFunctionKind(), aggregationFunctionMetadata);
    }

    protected Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName functionName) {
        return (Collection)this.memoizedFunctionsSupplier.get().values().stream().filter(function -> function.getSignature().getName().equals((Object)functionName)).collect(ImmutableList.toImmutableList());
    }

    protected UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName typeName) {
        return this.userDefinedTypes.get(typeName);
    }

    protected FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        if (functionHandle instanceof NativeFunctionHandle) {
            return this.getMetadataFromNativeFunctionHandle(functionHandle);
        }
        return (FunctionMetadata)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(x$0 -> this.sqlInvokedFunctionToMetadata((SqlInvokedFunction)x$0)).collect(MoreCollectors.onlyElement());
    }

    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        return (ScalarFunctionImplementation)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(x$0 -> this.sqlInvokedFunctionToImplementation((SqlInvokedFunction)x$0)).collect(MoreCollectors.onlyElement());
    }

    public synchronized void createFunction(SqlInvokedFunction function, boolean replace) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Create Function is not supported in NativeFunctionNamespaceManager");
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Alter Function is not supported in NativeFunctionNamespaceManager");
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Drop Function is not supported in NativeFunctionNamespaceManager");
    }

    public Collection<SqlInvokedFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return this.memoizedFunctionsSupplier.get().values();
    }

    public void addUserDefinedType(UserDefinedType userDefinedType) {
        QualifiedObjectName name = userDefinedType.getUserDefinedTypeName();
        Preconditions.checkArgument((!this.userDefinedTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type %s already registered", (Object)name);
        this.userDefinedTypes.put(name, userDefinedType);
    }

    public final FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        FunctionHandle functionHandle = super.getFunctionHandle(transactionHandle, signature);
        if (functionHandle == null) {
            return new NativeFunctionHandle(signature);
        }
        return functionHandle;
    }

    public static TypeSignature convertApplicableTypeToVariable(TypeSignature typeSignature) {
        List<TypeSignature> typeSignaturesList = NativeFunctionNamespaceManager.convertApplicableTypeToVariable((List<TypeSignature>)ImmutableList.of((Object)typeSignature));
        Preconditions.checkArgument((!typeSignaturesList.isEmpty() ? 1 : 0) != 0, (Object)("Type signature list is empty for : " + typeSignature));
        return typeSignaturesList.get(0);
    }

    public static List<TypeSignature> convertApplicableTypeToVariable(List<TypeSignature> typeSignatures) {
        ArrayList<TypeSignature> newTypeSignaturesList = new ArrayList<TypeSignature>();
        for (TypeSignature typeSignature : typeSignatures) {
            if (!typeSignature.getParameters().isEmpty()) {
                TypeSignature newTypeSignature = new TypeSignature(typeSignature.getBase(), NativeFunctionNamespaceManager.getTypeSignatureParameters(typeSignature, typeSignature.getParameters()));
                newTypeSignaturesList.add(newTypeSignature);
                continue;
            }
            newTypeSignaturesList.add(typeSignature);
        }
        return newTypeSignaturesList;
    }

    @VisibleForTesting
    public FunctionDefinitionProvider getFunctionDefinitionProvider() {
        return this.functionDefinitionProvider;
    }

    private static List<TypeSignatureParameter> getTypeSignatureParameters(TypeSignature typeSignature, List<TypeSignatureParameter> typeSignatureParameterList) {
        ArrayList<TypeSignatureParameter> newParameterTypeList = new ArrayList<TypeSignatureParameter>();
        for (TypeSignatureParameter parameter : typeSignatureParameterList) {
            if (parameter.isLongLiteral()) {
                newParameterTypeList.add(parameter);
                continue;
            }
            boolean isNamedTypeSignature = parameter.isNamedTypeSignature();
            TypeSignature parameterTypeSignature = isNamedTypeSignature ? parameter.getNamedTypeSignature().getTypeSignature() : parameter.getTypeSignature();
            if (parameterTypeSignature.getParameters().isEmpty()) {
                boolean changeTypeToVariable = NativeFunctionNamespaceManager.isDecimalTypeBase(typeSignature.getBase());
                if (changeTypeToVariable) {
                    newParameterTypeList.add(TypeSignatureParameter.of((String)parameterTypeSignature.getBase()));
                    continue;
                }
                if (isNamedTypeSignature) {
                    newParameterTypeList.add(TypeSignatureParameter.of((NamedTypeSignature)parameter.getNamedTypeSignature()));
                    continue;
                }
                newParameterTypeList.add(TypeSignatureParameter.of((TypeSignature)parameterTypeSignature));
                continue;
            }
            TypeSignature newTypeSignature = new TypeSignature(parameterTypeSignature.getBase(), NativeFunctionNamespaceManager.getTypeSignatureParameters(parameterTypeSignature.getStandardTypeSignature(), parameterTypeSignature.getParameters()));
            if (isNamedTypeSignature) {
                newParameterTypeList.add(TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), newTypeSignature)));
                continue;
            }
            newParameterTypeList.add(TypeSignatureParameter.of((TypeSignature)newTypeSignature));
        }
        return newParameterTypeList;
    }

    private static boolean isDecimalTypeBase(String typeBase) {
        return typeBase.equals("decimal");
    }

    private synchronized void createFunction(SqlInvokedFunction function) {
        this.checkFunctionLanguageSupported(function);
        SqlFunctionId functionId = function.getFunctionId();
        if (this.functions.containsKey(function.getFunctionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_FUNCTION_ERROR, String.format("Function '%s' already exists", functionId.getId()));
        }
        this.functions.put(functionId, function.withVersion("1"));
    }

    private SqlFunction getSqlFunctionFromSignature(Signature signature) {
        try {
            return ((SqlFunctionSupplier)this.specializedFunctionKeyCache.getUnchecked((Object)signature)).getFunction();
        }
        catch (UncheckedExecutionException e) {
            throw NativeFunctionNamespaceManager.convertToPrestoException(e, String.format("Error getting FunctionMetadata for signature: %s", signature));
        }
    }

    private FunctionMetadata getMetadataFromNativeFunctionHandle(SqlFunctionHandle functionHandle) {
        NativeFunctionHandle nativeFunctionHandle = (NativeFunctionHandle)functionHandle;
        Signature signature = nativeFunctionHandle.getSignature();
        SqlFunction function = this.getSqlFunctionFromSignature(signature);
        SqlInvokedFunction sqlFunction = (SqlInvokedFunction)function;
        return new FunctionMetadata(signature.getName(), signature.getArgumentTypes(), (List)sqlFunction.getParameters().stream().map(Parameter::getName).collect(ImmutableList.toImmutableList()), signature.getReturnType(), function.getSignature().getKind(), sqlFunction.getRoutineCharacteristics().getLanguage(), this.getFunctionImplementationType(sqlFunction), function.isDeterministic(), function.isCalledOnNullInput(), sqlFunction.getVersion(), function.getComplexTypeFunctionDescriptor());
    }

    private static PrestoException convertToPrestoException(UncheckedExecutionException exception, String failureMessage) {
        Throwable cause = exception.getCause();
        if (cause instanceof PrestoException) {
            return (PrestoException)cause;
        }
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, failureMessage, cause);
    }
}

