/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.nativechecker;

import com.facebook.presto.common.ErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanConversionFailureInfo {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String type;
    private final String message;
    private final PlanConversionFailureInfo cause;
    private final List<PlanConversionFailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorCode errorCode;

    @JsonCreator
    public PlanConversionFailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") PlanConversionFailureInfo cause, @JsonProperty(value="suppressed") List<PlanConversionFailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorCode") ErrorCode errorCode) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorCode = errorCode;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public PlanConversionFailureInfo getCause() {
        return this.cause;
    }

    @JsonProperty
    public List<PlanConversionFailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public RuntimeException toException() {
        return PlanConversionFailureInfo.toException(this);
    }

    private static FailureException toException(PlanConversionFailureInfo failureInfo) {
        if (failureInfo == null) {
            return null;
        }
        FailureException failure = new FailureException(failureInfo.getType(), failureInfo.getMessage(), PlanConversionFailureInfo.toException(failureInfo.getCause()));
        for (PlanConversionFailureInfo suppressed : failureInfo.getSuppressed()) {
            failure.addSuppressed(PlanConversionFailureInfo.toException(suppressed));
        }
        StackTraceElement[] stackTrace = (StackTraceElement[])failureInfo.getStack().stream().map(PlanConversionFailureInfo::toStackTraceElement).toArray(StackTraceElement[]::new);
        failure.setStackTrace(stackTrace);
        return failure;
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }

    private static class FailureException
    extends RuntimeException {
        private final String type;

        FailureException(String type, String message, FailureException cause) {
            super(message, cause);
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message != null) {
                return this.type + ": " + message;
            }
            return this.type;
        }
    }
}

