/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.nativechecker;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.sidecar.nativechecker.NativePlanCheckerConfig;
import com.facebook.presto.sidecar.nativechecker.NativePlanCheckerProvider;
import com.facebook.presto.sidecar.nativechecker.SimplePlanFragmentSerializer;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.PlanCheckerProviderContext;
import com.facebook.presto.spi.plan.PlanCheckerProviderFactory;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.facebook.presto.spi.plan.SimplePlanFragmentSerde;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Map;
import java.util.Objects;

public class NativePlanCheckerProviderFactory
implements PlanCheckerProviderFactory {
    private final ClassLoader classLoader;

    public NativePlanCheckerProviderFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "native";
    }

    public PlanCheckerProvider create(Map<String, String> properties, PlanCheckerProviderContext planCheckerProviderContext) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{binder -> {
                ConfigBinder.configBinder((Binder)binder).bindConfig(NativePlanCheckerConfig.class, "native-plan-checker");
                binder.install((Module)new JsonModule());
                binder.bind(NodeManager.class).toInstance((Object)planCheckerProviderContext.getNodeManager());
                binder.bind(SimplePlanFragmentSerde.class).toInstance((Object)planCheckerProviderContext.getSimplePlanFragmentSerde());
                JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(SimplePlanFragment.class).to(SimplePlanFragmentSerializer.class).in(Scopes.SINGLETON);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SimplePlanFragment.class);
                binder.bind(PlanCheckerProvider.class).to(NativePlanCheckerProvider.class).in(Scopes.SINGLETON);
            }});
            Injector injector = app.noStrictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(properties).quiet().initialize();
            PlanCheckerProvider planCheckerProvider = (PlanCheckerProvider)injector.getInstance(PlanCheckerProvider.class);
            return planCheckerProvider;
        }
    }
}

