/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.sessionpropertyproviders;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.sidecar.ForSidecarInfo;
import com.facebook.presto.sidecar.sessionpropertyproviders.NativeSystemSessionPropertyProviderConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.session.SessionPropertyMetadata;
import com.facebook.presto.spi.session.WorkerSessionPropertyProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class NativeSystemSessionPropertyProvider
implements WorkerSessionPropertyProvider {
    private static final Logger log = Logger.get(NativeSystemSessionPropertyProvider.class);
    private final NodeManager nodeManager;
    private final TypeManager typeManager;
    private final JsonCodec<List<SessionPropertyMetadata>> nativeSessionPropertiesJsonCodec;
    private final Supplier<List<PropertyMetadata<?>>> memoizedSessionPropertiesSupplier;
    private final HttpClient httpClient;
    private static final String SESSION_PROPERTIES_ENDPOINT = "/v1/properties/session";

    @Inject
    public NativeSystemSessionPropertyProvider(@ForSidecarInfo HttpClient httpClient, JsonCodec<List<SessionPropertyMetadata>> nativeSessionPropertiesJsonCodec, NodeManager nodeManager, TypeManager typeManager, NativeSystemSessionPropertyProviderConfig config) {
        this.nativeSessionPropertiesJsonCodec = Objects.requireNonNull(nativeSessionPropertiesJsonCodec, "nativeSessionPropertiesJsonCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "typeManager is null");
        Objects.requireNonNull(config, "config is null");
        this.memoizedSessionPropertiesSupplier = Suppliers.memoizeWithExpiration(this::fetchSessionProperties, (long)config.getSessionPropertiesCacheExpiration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return (List)this.memoizedSessionPropertiesSupplier.get();
    }

    private List<PropertyMetadata<?>> fetchSessionProperties() {
        try {
            ArrayList propertyMetadataList = new ArrayList();
            Request request = Request.Builder.prepareGet().setUri(this.getSidecarLocation()).build();
            List nativeSessionProperties = (List)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.nativeSessionPropertiesJsonCodec));
            for (SessionPropertyMetadata sessionProperty : nativeSessionProperties) {
                PropertyMetadata<?> propertyMetadata = this.toPropertyMetadata(sessionProperty);
                propertyMetadataList.add(propertyMetadata);
            }
            return propertyMetadataList;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Failed to get session properties from sidecar.", (Throwable)e);
        }
    }

    public PropertyMetadata<?> toPropertyMetadata(SessionPropertyMetadata data) {
        PropertyMetadata propertyMetadata;
        Objects.requireNonNull(data, "data is null");
        Type type = this.typeManager.getType(data.getTypeSignature());
        if (type == BooleanType.BOOLEAN) {
            propertyMetadata = PropertyMetadata.booleanProperty((String)data.getName(), (String)data.getDescription(), (Boolean)Boolean.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else if (type == IntegerType.INTEGER) {
            propertyMetadata = PropertyMetadata.integerProperty((String)data.getName(), (String)data.getDescription(), (Integer)Integer.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else if (type == BigintType.BIGINT) {
            propertyMetadata = PropertyMetadata.longProperty((String)data.getName(), (String)data.getDescription(), (Long)Long.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else if (type == VarcharType.VARCHAR) {
            propertyMetadata = PropertyMetadata.stringProperty((String)data.getName(), (String)data.getDescription(), (String)String.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else if (type == DoubleType.DOUBLE) {
            propertyMetadata = PropertyMetadata.doubleProperty((String)data.getName(), (String)data.getDescription(), (Double)Double.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else if (type == TinyintType.TINYINT) {
            propertyMetadata = PropertyMetadata.tinyIntProperty((String)data.getName(), (String)data.getDescription(), (Byte)Byte.valueOf(data.getDefaultValue()), (boolean)data.isHidden());
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown type");
        }
        return propertyMetadata;
    }

    private URI getSidecarLocation() {
        Node sidecarNode = this.nodeManager.getSidecarNode();
        return HttpUriBuilder.uriBuilder().scheme("http").host(sidecarNode.getHost()).port(sidecarNode.getHostAndPort().getPort()).appendPath(SESSION_PROPERTIES_ENDPOINT).build();
    }
}

