/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoConnector;
import com.facebook.presto.mongodb.MongoPageSinkProvider;
import com.facebook.presto.mongodb.MongoPageSourceProvider;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplitManager;
import com.facebook.presto.plugin.base.security.SslContextProvider;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import jakarta.inject.Singleton;
import java.util.Objects;

public class MongoClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(MongoConnector.class).in(Scopes.SINGLETON);
        binder.bind(MongoSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MongoPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MongoClientConfig.class);
    }

    @Singleton
    @Provides
    public static MongoSession createMongoSession(TypeManager typeManager, MongoClientConfig config) {
        Objects.requireNonNull(config, "config is null");
        MongoClientOptions.Builder options = MongoClientOptions.builder().connectionsPerHost(config.getConnectionsPerHost()).connectTimeout(config.getConnectionTimeout()).socketTimeout(config.getSocketTimeout()).socketKeepAlive(config.getSocketKeepAlive()).maxWaitTime(config.getMaxWaitTime()).minConnectionsPerHost(config.getMinConnectionsPerHost()).writeConcern(config.getWriteConcern().getWriteConcern());
        if (config.getRequiredReplicaSetName() != null) {
            options.requiredReplicaSetName(config.getRequiredReplicaSetName());
        }
        MongoClientModule.configureReadPreference(options, config);
        MongoClientModule.configureSsl(options, config);
        MongoClient client = new MongoClient(config.getSeeds(), config.getCredentials(), options.build());
        return new MongoSession(typeManager, client, config);
    }

    private static void configureReadPreference(MongoClientOptions.Builder options, MongoClientConfig config) {
        if (config.getReadPreferenceTags().isEmpty()) {
            options.readPreference(config.getReadPreference().getReadPreference());
        } else {
            options.readPreference(config.getReadPreference().getReadPreferenceWithTags(config.getReadPreferenceTags()));
        }
    }

    private static void configureSsl(MongoClientOptions.Builder options, MongoClientConfig config) {
        if (config.isTlsEnabled()) {
            SslContextProvider sslContextProvider = new SslContextProvider(config.getKeystorePath(), config.getKeystorePassword(), config.getTruststorePath(), config.getTruststorePassword());
            sslContextProvider.buildSslContext().ifPresent(sslContext -> {
                options.sslContext(sslContext);
                options.sslEnabled(true);
            });
        }
    }
}

