/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.presto.mongodb.ReadPreferenceType;
import com.facebook.presto.mongodb.WriteConcernType;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@DefunctConfig(value={"mongodb.connection-per-host"})
public class MongoClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter PORT_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();
    private static final Splitter TAGSET_SPLITTER = Splitter.on((char)'&').trimResults().omitEmptyStrings();
    private static final Splitter TAG_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();
    private String schemaCollection = "_schema";
    private List<ServerAddress> seeds = ImmutableList.of();
    private List<MongoCredential> credentials = ImmutableList.of();
    private int minConnectionsPerHost;
    private int connectionsPerHost = 100;
    private int maxWaitTime = 120000;
    private int connectionTimeout = 10000;
    private int socketTimeout;
    private boolean socketKeepAlive;
    private int cursorBatchSize;
    private ReadPreferenceType readPreference = ReadPreferenceType.PRIMARY;
    private List<TagSet> readPreferenceTagSets = ImmutableList.of();
    private WriteConcernType writeConcern = WriteConcernType.ACKNOWLEDGED;
    private String requiredReplicaSetName;
    private String implicitRowFieldPrefix = "_pos";
    private boolean tlsEnabled;
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String truststorePassword;
    private boolean caseSensitiveNameMatchingEnabled;

    @AssertTrue(message="'mongodb.tls.keystore-path', 'mongodb.tls.keystore-password', 'mongodb.tls.truststore-path' and 'mongodb.tls.truststore-password' must be empty when TLS is disabled")
    public @AssertTrue(message="'mongodb.tls.keystore-path', 'mongodb.tls.keystore-password', 'mongodb.tls.truststore-path' and 'mongodb.tls.truststore-password' must be empty when TLS is disabled") boolean isValidTlsConfig() {
        if (!this.tlsEnabled) {
            return this.keystorePath == null && this.keystorePassword == null && this.truststorePath == null && this.truststorePassword == null;
        }
        boolean validKeystore = this.keystorePath == null && this.keystorePassword == null || this.keystorePath != null && this.keystorePassword != null;
        boolean validTruststore = this.truststorePath == null && this.truststorePassword == null || this.truststorePath != null && this.truststorePassword != null;
        return validKeystore && validTruststore;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="mongodb.tls.enabled")
    @LegacyConfig(value={"mongodb.ssl.enabled"})
    public MongoClientConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public Optional<File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="mongodb.tls.keystore-path")
    public MongoClientConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="mongodb.tls.keystore-password")
    @ConfigSecuritySensitive
    public MongoClientConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="mongodb.tls.truststore-path")
    public MongoClientConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="mongodb.tls.truststore-password")
    @ConfigSecuritySensitive
    public MongoClientConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @NotNull
    public String getSchemaCollection() {
        return this.schemaCollection;
    }

    @Config(value="mongodb.schema-collection")
    public MongoClientConfig setSchemaCollection(String schemaCollection) {
        this.schemaCollection = schemaCollection;
        return this;
    }

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<ServerAddress> getSeeds() {
        return this.seeds;
    }

    @Config(value="mongodb.seeds")
    public MongoClientConfig setSeeds(String commaSeparatedList) {
        this.seeds = this.buildSeeds(SPLITTER.split((CharSequence)commaSeparatedList));
        return this;
    }

    public MongoClientConfig setSeeds(String ... seeds) {
        this.seeds = this.buildSeeds(Arrays.asList(seeds));
        return this;
    }

    @NotNull
    @Size(min=0)
    public @NotNull @Size(min=0) List<MongoCredential> getCredentials() {
        return this.credentials;
    }

    @Config(value="mongodb.credentials")
    public MongoClientConfig setCredentials(String credentials) {
        this.credentials = this.buildCredentials(SPLITTER.split((CharSequence)credentials));
        return this;
    }

    public MongoClientConfig setCredentials(String ... credentials) {
        this.credentials = this.buildCredentials(Arrays.asList(credentials));
        return this;
    }

    private List<ServerAddress> buildSeeds(Iterable<String> hostPorts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String hostPort : hostPorts) {
            List values = PORT_SPLITTER.splitToList((CharSequence)hostPort);
            Preconditions.checkArgument((values.size() == 1 || values.size() == 2 ? 1 : 0) != 0, (Object)"Invalid ServerAddress format. Requires host[:port]");
            if (values.size() == 1) {
                builder.add((Object)new ServerAddress((String)values.get(0)));
                continue;
            }
            builder.add((Object)new ServerAddress((String)values.get(0), Integer.parseInt((String)values.get(1))));
        }
        return builder.build();
    }

    private List<MongoCredential> buildCredentials(Iterable<String> userPasses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String userPass : userPasses) {
            int atPos = userPass.lastIndexOf(64);
            Preconditions.checkArgument((atPos > 0 ? 1 : 0) != 0, (Object)"Invalid credential format. Required user:password@collection");
            String userAndPassword = userPass.substring(0, atPos);
            String collection = userPass.substring(atPos + 1);
            int colonPos = userAndPassword.indexOf(58);
            Preconditions.checkArgument((colonPos > 0 ? 1 : 0) != 0, (Object)"Invalid credential format. Required user:password@collection");
            String user = userAndPassword.substring(0, colonPos);
            String password = userAndPassword.substring(colonPos + 1);
            builder.add((Object)MongoCredential.createCredential((String)user, (String)collection, (char[])password.toCharArray()));
        }
        return builder.build();
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Config(value="mongodb.min-connections-per-host")
    public MongoClientConfig setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    @Config(value="mongodb.connections-per-host")
    public MongoClientConfig setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Config(value="mongodb.max-wait-time")
    public MongoClientConfig setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="mongodb.connection-timeout")
    public MongoClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Config(value="mongodb.socket-timeout")
    public MongoClientConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    @Config(value="mongodb.socket-keep-alive")
    public MongoClientConfig setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    public ReadPreferenceType getReadPreference() {
        return this.readPreference;
    }

    @Config(value="mongodb.read-preference")
    public MongoClientConfig setReadPreference(ReadPreferenceType readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public List<TagSet> getReadPreferenceTags() {
        return this.readPreferenceTagSets;
    }

    @Config(value="mongodb.read-preference-tags")
    public MongoClientConfig setReadPreferenceTags(String readPreferenceTags) {
        this.readPreferenceTagSets = this.buildTagSets(TAGSET_SPLITTER.split((CharSequence)readPreferenceTags));
        return this;
    }

    private List<TagSet> buildTagSets(Iterable<String> tagSets) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String tagSet : tagSets) {
            builder.add((Object)new TagSet(this.buildTags(SPLITTER.split((CharSequence)tagSet))));
        }
        return builder.build();
    }

    private List<Tag> buildTags(Iterable<String> tags) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String tag : tags) {
            List values = TAG_SPLITTER.splitToList((CharSequence)tag);
            Preconditions.checkArgument((values.size() == 2 ? 1 : 0) != 0, (Object)"Invalid Tag format. Requires tagName:tagValue");
            builder.add((Object)new Tag((String)values.get(0), (String)values.get(1)));
        }
        return builder.build();
    }

    public WriteConcernType getWriteConcern() {
        return this.writeConcern;
    }

    @Config(value="mongodb.write-concern")
    public MongoClientConfig setWriteConcern(WriteConcernType writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Config(value="mongodb.required-replica-set")
    public MongoClientConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    @Config(value="mongodb.cursor-batch-size")
    public MongoClientConfig setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
        return this;
    }

    public String getImplicitRowFieldPrefix() {
        return this.implicitRowFieldPrefix;
    }

    @Config(value="mongodb.implicit-row-field-prefix")
    public MongoClientConfig setImplicitRowFieldPrefix(String implicitRowFieldPrefix) {
        this.implicitRowFieldPrefix = implicitRowFieldPrefix;
        return this;
    }

    public boolean isCaseSensitiveNameMatchingEnabled() {
        return this.caseSensitiveNameMatchingEnabled;
    }

    @Config(value="case-sensitive-name-matching")
    public MongoClientConfig setCaseSensitiveNameMatchingEnabled(boolean caseSensitiveNameMatchingEnabled) {
        this.caseSensitiveNameMatchingEnabled = caseSensitiveNameMatchingEnabled;
        return this;
    }
}

