/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplit;
import com.facebook.presto.mongodb.ObjectIdType;
import com.facebook.presto.mongodb.TypeUtils;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.mongodb.client.MongoCursor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MongoPageSource
implements ConnectorPageSource {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private static final int ROWS_PER_REQUEST = 1024;
    private final MongoCursor<Document> cursor;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private Document currentDoc;
    private long completedBytes;
    private long completedPositions;
    private boolean finished;
    private final PageBuilder pageBuilder;

    public MongoPageSource(MongoSession mongoSession, MongoSplit split, List<MongoColumnHandle> columns) {
        this.columnNames = columns.stream().map(MongoColumnHandle::getName).collect(Collectors.toList());
        this.columnTypes = columns.stream().map(MongoColumnHandle::getType).collect(Collectors.toList());
        this.cursor = mongoSession.execute(split, columns);
        this.currentDoc = null;
        this.pageBuilder = new PageBuilder(this.columnTypes);
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public Page getNextPage() {
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        for (int i = 0; i < 1024; ++i) {
            if (!this.cursor.hasNext()) {
                this.finished = true;
                break;
            }
            this.currentDoc = (Document)this.cursor.next();
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), this.currentDoc.get((Object)this.columnNames.get(column)), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        this.completedBytes += page.getSizeInBytes();
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block13: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block13;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block13;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block13;
                    }
                    if (type.equals(DateType.DATE)) {
                        long utcMillis = ((Date)value).getTime();
                        type.writeLong(output, TimeUnit.MILLISECONDS.toDays(utcMillis));
                        break block13;
                    }
                    if (type.equals(TimeType.TIME)) {
                        type.writeLong(output, (long)ZonedDateTime.ofInstant(((Date)value).toInstant(), UTC_ZONE_ID).get(ChronoField.MILLI_OF_DAY));
                        break block13;
                    }
                    if (type.equals(TimestampType.TIMESTAMP)) {
                        type.writeLong(output, ((Date)value).getTime());
                        break block13;
                    }
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block13;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block13;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block13;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private String toVarcharValue(Object value) {
        if (value instanceof Collection) {
            return "[" + String.join((CharSequence)", ", ((Collection)value).stream().map(this::toVarcharValue).collect(Collectors.toList())) + "]";
        }
        if (value instanceof Document) {
            return ((Document)value).toJson();
        }
        return String.valueOf(value);
    }

    private void writeSlice(BlockBuilder output, Type type, Object value) {
        String base = type.getTypeSignature().getBase();
        if (base.equals("varchar")) {
            type.writeSlice(output, Slices.utf8Slice((String)this.toVarcharValue(value)));
        } else if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])((ObjectId)value).toByteArray()));
        } else if (type.equals(VarbinaryType.VARBINARY)) {
            if (value instanceof Binary) {
                type.writeSlice(output, Slices.wrappedBuffer((byte[])((Binary)value).getData()));
            } else {
                output.appendNull();
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (TypeUtils.isArrayType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = output.beginBlockEntry();
                ((List)value).forEach(element -> this.appendTo((Type)type.getTypeParameters().get(0), element, builder));
                output.closeEntry();
                return;
            }
        } else if (TypeUtils.isMapType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = output.beginBlockEntry();
                for (Object element2 : (List)value) {
                    Map document;
                    if (!(element2 instanceof Map) || !(document = (Map)element2).containsKey("key") || !document.containsKey("value")) continue;
                    this.appendTo((Type)type.getTypeParameters().get(0), document.get("key"), builder);
                    this.appendTo((Type)type.getTypeParameters().get(1), document.get("value"), builder);
                }
                output.closeEntry();
                return;
            }
            if (value instanceof Map) {
                BlockBuilder builder = output.beginBlockEntry();
                Map document = (Map)value;
                for (Map.Entry entry : document.entrySet()) {
                    this.appendTo((Type)type.getTypeParameters().get(0), entry.getKey(), builder);
                    this.appendTo((Type)type.getTypeParameters().get(1), entry.getValue(), builder);
                }
                output.closeEntry();
                return;
            }
        } else if (TypeUtils.isRowType(type)) {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                BlockBuilder builder = output.beginBlockEntry();
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                    TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                    fieldNames.add(parameter.getNamedTypeSignature().getName().orElse("field" + i));
                }
                Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object)type);
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    this.appendTo((Type)type.getTypeParameters().get(index), mapValue.get(fieldNames.get(index)), builder);
                }
                output.closeEntry();
                return;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                BlockBuilder builder = output.beginBlockEntry();
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    if (index < listValue.size()) {
                        this.appendTo((Type)type.getTypeParameters().get(index), listValue.get(index), builder);
                        continue;
                    }
                    builder.appendNull();
                }
                output.closeEntry();
                return;
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + type.getTypeSignature());
        }
        output.appendNull();
    }

    public void close() {
        this.cursor.close();
    }
}

