/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.mongodb.MongoClientModule;
import com.facebook.presto.mongodb.MongoConnector;
import com.facebook.presto.mongodb.MongoHandleResolver;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class MongoConnectorFactory
implements ConnectorFactory {
    private final String name;

    public MongoConnectorFactory(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new MongoHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MongoClientModule(), binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(MongoConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

