/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoIndex;
import com.facebook.presto.mongodb.MongoInsertTableHandle;
import com.facebook.presto.mongodb.MongoOutputTableHandle;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoTable;
import com.facebook.presto.mongodb.MongoTableHandle;
import com.facebook.presto.mongodb.MongoTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class MongoMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(MongoMetadata.class);
    private final MongoSession mongoSession;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public MongoMetadata(MongoSession mongoSession) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.mongoSession.getAllSchemas();
    }

    public MongoTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        try {
            return this.mongoSession.getTable(tableName).getTableHandle();
        }
        catch (TableNotFoundException e) {
            log.debug((Throwable)e, "Table(%s) not found", new Object[]{tableName});
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = MongoMetadata.getTableName(tableHandle);
        return this.getTableMetadata(session, tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.mongoSession.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
            }
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        List<MongoColumnHandle> columns = this.mongoSession.getTable(table.getSchemaTableName()).getColumns();
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (MongoColumnHandle columnHandle : columns) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (NotFoundException notFoundException) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((MongoColumnHandle)columnHandle).toColumnMetadata();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        MongoTableHandle tableHandle = (MongoTableHandle)table;
        Optional partitioningColumns = Optional.empty();
        ImmutableList.Builder localProperties = ImmutableList.builder();
        MongoTable tableInfo = this.mongoSession.getTable(tableHandle.getSchemaTableName());
        Map<String, ColumnHandle> columns = this.getColumnHandles(session, tableHandle);
        for (MongoIndex index : tableInfo.getIndexes()) {
            for (MongoIndex.MongodbIndexKey key : index.getKeys()) {
                if (!key.getSortOrder().isPresent() || columns.get(key.getName()) == null) continue;
                localProperties.add((Object)new SortingProperty((Object)columns.get(key.getName()), key.getSortOrder().get()));
            }
        }
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new MongoTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()), Optional.empty(), TupleDomain.all(), Optional.empty(), partitioningColumns, Optional.empty(), (List)localProperties.build());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        MongoTableLayoutHandle layout = (MongoTableLayoutHandle)handle;
        return this.getTableLayouts(session, layout.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).get(0).getTableLayout();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.mongoSession.createTable(tableMetadata.getTable(), MongoMetadata.buildColumnHandles(tableMetadata));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.dropTable(table.getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        throw new UnsupportedOperationException();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        List<MongoColumnHandle> columns = MongoMetadata.buildColumnHandles(tableMetadata);
        this.mongoSession.createTable(tableMetadata.getTable(), columns);
        this.setRollback(() -> this.mongoSession.dropTable(tableMetadata.getTable()));
        return new MongoOutputTableHandle(tableMetadata.getTable(), columns.stream().filter(c -> !c.isHidden()).collect(Collectors.toList()));
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        this.clearRollback();
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        List<MongoColumnHandle> columns = this.mongoSession.getTable(table.getSchemaTableName()).getColumns();
        return new MongoInsertTableHandle(table.getSchemaTableName(), columns.stream().filter(c -> !c.isHidden()).collect(Collectors.toList()));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((MongoTableHandle)tableHandle).getSchemaTableName();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        MongoTableHandle tableHandle = this.mongoSession.getTable(tableName).getTableHandle();
        ImmutableList columns = ImmutableList.copyOf((Collection)this.getColumnHandles(session, tableHandle).values().stream().map(MongoColumnHandle.class::cast).map(MongoColumnHandle::toColumnMetadata).collect(Collectors.toList()));
        return new ConnectorTableMetadata(tableName, (List)columns);
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    private static List<MongoColumnHandle> buildColumnHandles(ConnectorTableMetadata tableMetadata) {
        return tableMetadata.getColumns().stream().map(m -> new MongoColumnHandle(m.getName(), m.getType(), m.isHidden())).collect(Collectors.toList());
    }
}

