/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoMetadata;
import com.facebook.presto.mongodb.MongoPageSinkProvider;
import com.facebook.presto.mongodb.MongoPageSourceProvider;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplitManager;
import com.facebook.presto.mongodb.MongoTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class MongoConnector
implements Connector {
    private final MongoSession mongoSession;
    private final MongoSplitManager splitManager;
    private final MongoPageSourceProvider pageSourceProvider;
    private final MongoPageSinkProvider pageSinkProvider;
    private final ConcurrentMap<ConnectorTransactionHandle, MongoMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MongoMetadata>();

    @Inject
    public MongoConnector(MongoSession mongoSession, MongoSplitManager splitManager, MongoPageSourceProvider pageSourceProvider, MongoPageSinkProvider pageSinkProvider) {
        this.mongoSession = mongoSession;
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        MongoTransactionHandle transaction = new MongoTransactionHandle();
        this.transactions.put(transaction, new MongoMetadata(this.mongoSession));
        return transaction;
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MongoMetadata metadata = (MongoMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public void shutdown() {
        this.mongoSession.shutdown();
    }
}

