/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplit;
import com.facebook.presto.mongodb.ObjectIdType;
import com.facebook.presto.mongodb.TypeUtils;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class MongoPageSource
implements ConnectorPageSource {
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);
    private static final int ROWS_PER_REQUEST = 1024;
    private final MongoCursor<Document> cursor;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private Document currentDoc;
    private long count;
    private long totalCount;
    private boolean finished;

    public MongoPageSource(MongoSession mongoSession, MongoSplit split, List<MongoColumnHandle> columns) {
        this.columnNames = columns.stream().map(MongoColumnHandle::getName).collect(Collectors.toList());
        this.columnTypes = columns.stream().map(MongoColumnHandle::getType).collect(Collectors.toList());
        this.cursor = mongoSession.execute(split, columns);
        this.currentDoc = null;
    }

    public long getTotalBytes() {
        return this.totalCount;
    }

    public long getCompletedBytes() {
        return this.count;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public Page getNextPage() {
        PageBuilder pageBuilder = new PageBuilder(this.columnTypes);
        this.count = 0L;
        for (int i = 0; i < 1024; ++i) {
            if (!this.cursor.hasNext()) {
                this.finished = true;
                break;
            }
            this.currentDoc = (Document)this.cursor.next();
            ++this.count;
            pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), this.currentDoc.get((Object)this.columnNames.get(column)), output);
            }
        }
        this.totalCount += this.count;
        return pageBuilder.build();
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block13: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block13;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block13;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block13;
                    }
                    if (type.equals(DateType.DATE)) {
                        long utcMillis = ((Date)value).getTime();
                        type.writeLong(output, TimeUnit.MILLISECONDS.toDays(utcMillis));
                        break block13;
                    }
                    if (type.equals(TimeType.TIME)) {
                        type.writeLong(output, (long)UTC_CHRONOLOGY.millisOfDay().get(((Date)value).getTime()));
                        break block13;
                    }
                    if (type.equals(TimestampType.TIMESTAMP)) {
                        type.writeLong(output, ((Date)value).getTime());
                        break block13;
                    }
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block13;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block13;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block13;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private void writeSlice(BlockBuilder output, Type type, Object value) {
        String base = type.getTypeSignature().getBase();
        if (base.equals("varchar")) {
            type.writeSlice(output, Slices.utf8Slice((String)value.toString()));
        } else if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])((ObjectId)value).toByteArray()));
        } else if (type.equals(VarbinaryType.VARBINARY)) {
            if (value instanceof Binary) {
                type.writeSlice(output, Slices.wrappedBuffer((byte[])((Binary)value).getData()));
            } else {
                output.appendNull();
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (TypeUtils.isArrayType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = this.createParametersBlockBuilder(type, ((List)value).size());
                ((List)value).forEach(element -> this.appendTo((Type)type.getTypeParameters().get(0), element, builder));
                type.writeObject(output, (Object)builder.build());
                return;
            }
        } else if (TypeUtils.isMapType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = this.createParametersBlockBuilder(type, ((List)value).size());
                for (Object element2 : (List)value) {
                    Map document;
                    if (!(element2 instanceof Map) || !(document = (Map)element2).containsKey("key") || !document.containsKey("value")) continue;
                    this.appendTo((Type)type.getTypeParameters().get(0), document.get("key"), builder);
                    this.appendTo((Type)type.getTypeParameters().get(1), document.get("value"), builder);
                }
                type.writeObject(output, (Object)builder.build());
                return;
            }
        } else if (TypeUtils.isRowType(type)) {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                BlockBuilder builder = this.createParametersBlockBuilder(type, mapValue.size());
                List fieldNames = type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).collect(Collectors.toList());
                Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object[])new Object[]{type});
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    this.appendTo((Type)type.getTypeParameters().get(index), mapValue.get(((String)fieldNames.get(index)).toString()), builder);
                }
                type.writeObject(output, (Object)builder.build());
                return;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                BlockBuilder builder = this.createParametersBlockBuilder(type, listValue.size());
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    if (index < listValue.size()) {
                        this.appendTo((Type)type.getTypeParameters().get(index), listValue.get(index), builder);
                        continue;
                    }
                    builder.appendNull();
                }
                type.writeObject(output, (Object)builder.build());
                return;
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + type.getTypeSignature());
        }
        output.appendNull();
    }

    private BlockBuilder createParametersBlockBuilder(Type type, int size) {
        List params = type.getTypeParameters();
        if (TypeUtils.isArrayType(type)) {
            return ((Type)params.get(0)).createBlockBuilder(new BlockBuilderStatus(), size);
        }
        return new InterleavedBlockBuilder(params, new BlockBuilderStatus(), size * params.size());
    }

    public void close() throws IOException {
        this.cursor.close();
    }
}

