/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoConnectorId;
import com.facebook.presto.mongodb.MongoSplit;
import com.facebook.presto.mongodb.MongoTableHandle;
import com.facebook.presto.mongodb.MongoTableLayoutHandle;
import com.facebook.presto.mongodb.TypeUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class MongoSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final List<HostAddress> addresses;

    @Inject
    public MongoSplitManager(MongoConnectorId connectorId, MongoClientConfig config) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.addresses = config.getSeeds().stream().map(s -> HostAddress.fromParts((String)s.getHost(), (int)s.getPort())).collect(Collectors.toList());
    }

    public ConnectorSplitSource getSplits(ConnectorSession session, ConnectorTableLayoutHandle layout) {
        MongoTableLayoutHandle tableLayout = TypeUtils.checkType(layout, MongoTableLayoutHandle.class, "layout");
        MongoTableHandle tableHandle = tableLayout.getTable();
        MongoSplit split = new MongoSplit(this.connectorId, tableHandle.getSchemaTableName(), tableLayout.getTupleDomain(), this.addresses);
        return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of((Object)split));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }
}

